/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.load.support;

import com.dc.xml.binding.URIMap;
import java.net.URI;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class URIMapImpl
implements URIMap {
    String uri_pattern;
    String rulepath_p;
    String confpath_p;

    public URIMapImpl(String uriPatt, String rulePathPatt, String confPathPatt) {
        this.uri_pattern = uriPatt;
        this.rulepath_p = rulePathPatt;
        this.confpath_p = confPathPatt;
    }

    public boolean match(URI uri) {
        Pattern pattern = Pattern.compile(this.uri_pattern);
        return pattern.matcher(uri.toString()).matches();
    }

    public String getDataPath(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("uri cannot be null");
        }
        return this.uri2path(this.confpath_p, uri);
    }

    public String getRulePath(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("uri cannot be null");
        }
        return this.uri2path(this.rulepath_p, uri);
    }

    protected String uri2path(String pathpattern, URI uri) {
        StringTokenizer stk = new StringTokenizer(uri.getSchemeSpecificPart(), ":/");
        String[] tokens = new String[stk.countTokens()];
        int i = 0;
        while (stk.hasMoreTokens()) {
            tokens[i] = stk.nextToken();
            ++i;
        }
        String patternStr = "(\\$\\{[0-9]{1,}\\})";
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(pathpattern);
        StringBuffer buf = new StringBuffer();
        boolean found = false;
        while (found = matcher.find()) {
            String replaceStr = matcher.group();
            int index = Integer.parseInt(replaceStr.substring(replaceStr.indexOf(123) + 1, replaceStr.lastIndexOf(125)));
            replaceStr = tokens[index];
            matcher.appendReplacement(buf, replaceStr);
        }
        matcher.appendTail(buf);
        String result = buf.toString();
        return result;
    }
}

