/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.load.support;

import com.dc.xml.binding.ConfigException;
import com.dc.xml.binding.ExtDigesterHelper;
import com.dc.xml.binding.URIMap;
import com.dc.xml.loading.Load;
import com.dc.xml.loading.LoadListener;
import com.dc.xml.loading.LoadResult;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoadHelper {
    public static final String RESULT = "RESULT";
    private static Map threads = new HashMap();
    private static String pname = LoadHelper.class.getName();
    public static final String URI_MAP_SCRIPT;
    public static final String START_MISSION_SCRIPT;
    public static final String URI_MAPS;
    public static final String CLASSLOADER;
    private static Log log;
    private static final LoadListener ll;

    public static LoadResult load(URL urnconf, ClassLoader cl) {
        HashMap name2value;
        if (urnconf == null) {
            throw new NullPointerException("URL for urn-conf cannot be null");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(urnconf.toString() + " load start"));
        }
        if ((name2value = (HashMap)threads.get(Thread.currentThread())) == null) {
            name2value = new HashMap();
            threads.put(Thread.currentThread(), name2value);
        }
        try {
            LoadResult result = new LoadResult();
            LoadHelper.put(RESULT, result);
            result.addListener(ll);
            ArrayList urimaps = new ArrayList();
            result.putProduct(CLASSLOADER, cl);
            result.putProduct(URI_MAPS, urimaps);
            ExtDigesterHelper.load(LoadHelper.class.getClassLoader().getResource(URI_MAP_SCRIPT), cl, urnconf, (Object)result);
            Load start_mission = (Load)ExtDigesterHelper.load(LoadHelper.class.getClassLoader().getResource(START_MISSION_SCRIPT), cl, urnconf, (Object)result);
            start_mission.load(result);
            if (log.isInfoEnabled()) {
                log.info((Object)(urnconf.toString() + " load end"));
            }
            LoadResult loadResult = result;
            return loadResult;
        }
        catch (RuntimeException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)(urnconf.toString() + " load error"), (Throwable)e);
            }
            throw e;
        }
        finally {
            threads.remove(Thread.currentThread());
        }
    }

    public static URL[] findConfig(URI uri, LoadResult lr) {
        URL[] us = null;
        String ruleP = null;
        String dataP = null;
        List maps = (List)lr.getProduct(URI_MAPS);
        ClassLoader cl = (ClassLoader)lr.getProduct(CLASSLOADER);
        for (int i = 0; i < maps.size(); ++i) {
            URIMap u = (URIMap)maps.get(i);
            if (!u.match(uri)) continue;
            ruleP = u.getRulePath(uri);
            dataP = u.getDataPath(uri);
            us = new URL[]{cl.getResource(ruleP), cl.getResource(dataP)};
            break;
        }
        if (us == null || us.length < 2 || us[0] == null || us[1] == null) {
            ConfigException ce = new ConfigException("UriCannotLocateToUrl");
            ce.addScene("URI", uri);
            ce.addScene("RulePath", ruleP);
            ce.addScene("RuleURL", us.length > 0 ? us[0] : null);
            ce.addScene("DataPath", dataP);
            ce.addScene("DataURL", us.length > 1 ? us[1] : null);
            throw ce;
        }
        return us;
    }

    public static void put(String name, Object o) {
        ((Map)threads.get(Thread.currentThread())).put(name, o);
    }

    public static Object get(String name) {
        return ((Map)threads.get(Thread.currentThread())).get(name);
    }

    static {
        pname = pname.substring(0, pname.lastIndexOf("."));
        pname = pname.replace('.', '/');
        URI_MAP_SCRIPT = pname + "/uri.rule.xml";
        START_MISSION_SCRIPT = pname + "/mission.rule.xml";
        URI_MAPS = pname + "/urimaps";
        CLASSLOADER = pname + "/classloader";
        log = LogFactory.getLog((Class)LoadHelper.class);
        ll = new LoadListener(){

            public void addFailer(Load mission, Throwable th) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Load mission[" + mission + "] failed"), th);
                }
            }

            public void startLoad(Load mission) {
                if (log.isInfoEnabled()) {
                    log.info((Object)(mission + " started"));
                }
            }

            public void endLoad(Load mission) {
                if (log.isInfoEnabled()) {
                    log.info((Object)(mission + " ended"));
                }
            }
        };
    }
}

