/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.load.support;

import com.dc.eai.load.support.LoadHelper;
import com.dc.xml.binding.ConfigException;
import com.dc.xml.binding.ExtDigesterHelper;
import com.dc.xml.loading.AbstractLoad;
import com.dc.xml.loading.LoadResult;
import java.net.URI;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class LoadCase
extends AbstractLoad {
    private static Log logger = LogFactory.getLog((Class)LoadCase.class);

    public LoadCase(String name) {
        this.name = name;
    }

    public void load(LoadResult result) {
        result.startLoad(this);
        try {
            URI uri;
            URL[] conf;
            ClassLoader cl = null;
            Object product = null;
            cl = (ClassLoader)result.getProduct(LoadHelper.CLASSLOADER);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("load " + this.name + " with " + cl));
            }
            if ((conf = LoadHelper.findConfig(uri = new URI(this.name), result)) == null || conf.length < 2 || conf[0] == null || conf[1] == null) {
                ConfigException ce = new ConfigException("UriCannotLocateToUrl");
                ce.addScene("URI", this.name);
                ce.addScene("[rule,data]", conf);
                throw ce;
            }
            product = ExtDigesterHelper.load(conf[0], cl, conf[1]);
            if (product != null && !(product instanceof LoadResult)) {
                result.putProduct(this.name, product);
            }
        }
        catch (Exception e) {
            result.addFailer(this, e);
        }
        result.endLoad(this);
    }
}

