/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.load.impl;

import com.dc.eai.component.ComponentManager;
import com.dc.eai.load.AbstractComponentLoader;
import com.dc.eai.load.ComponentMonitor;
import com.dc.eai.load.impl.ConsoleComponentLoader;
import com.dc.eai.load.impl.TimerComponentLoader;
import com.dc.eai.load.impl.UnreloadableComponentLoader;
import com.dc.eai.load.impl.VaryComponentLoader;
import com.dc.util.classloader.PathClassFinder;
import com.dc.util.classloader.Source;
import com.dc.util.xml.CommonData;
import com.dc.util.xml.XMLCommonData;
import com.dc.util.xml.store.XMLoader;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ComponentMonitorImpl
implements ComponentMonitor {
    private Log log = LogFactory.getLog((Class)ComponentMonitorImpl.class);
    Map url2tstamp = new HashMap();
    Map url2compName = new HashMap();
    ClassLoader cl = null;

    public ComponentMonitorImpl(ClassLoader cl) {
        this.cl = cl;
    }

    public synchronized void sync(List compUrlHomes, ComponentManager cmgr) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"------\u7ec4\u4ef6\u914d\u7f6e\u6587\u4ef6\u68c0\u67e5\u5f00\u59cb");
        }
        ClassLoader cl_old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.cl);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("ContextClassLoader=[" + this.cl + "]"));
        }
        HashSet<URL> componentURLs = new HashSet<URL>();
        for (int i = 0; i < compUrlHomes.size(); ++i) {
            File f = null;
            try {
                f = new File(new URL((String)compUrlHomes.get(i)).getFile());
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("\u7ec4\u4ef6\u76ee\u5f55URL=[" + (String)compUrlHomes.get(i) + "]"));
                }
            }
            catch (MalformedURLException e) {
                IllegalArgumentException ia = new IllegalArgumentException("WrongURL: " + (String)compUrlHomes.get(i) + "\n" + e.getMessage());
                throw ia;
            }
            File[] children = f.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.isDirectory() || pathname.getName().endsWith(".jar");
                }
            });
            if (children == null) continue;
            for (int j = 0; j < children.length; ++j) {
                Source s = new PathClassFinder(children[j].getAbsolutePath()).getSource("component.xml");
                if (s == null) continue;
                if (this.url2tstamp.keySet().contains(s.getURL())) {
                    Timestamp t_old;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("\u5df2\u6709\u7684\u7ec4\u4ef6=[" + s + "]"));
                    }
                    if ((t_old = (Timestamp)this.url2tstamp.get(s.getURL())).getTime() != s.lastModified()) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)"\u7ec4\u4ef6\u63cf\u8ff0\u53d8\u66f4");
                        }
                        CommonData root = this.loadXML(s);
                        cmgr.removeComponent((String)root.getChild("component").getAttribute("name"));
                        this.addComponent(root, cmgr, children[j]);
                        this.url2tstamp.put(s.getURL(), new Timestamp(s.lastModified()));
                    }
                } else {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("\u65b0\u589e\u7684\u7ec4\u4ef6=[" + s + "]"));
                    }
                    CommonData root = this.loadXML(s);
                    this.addComponent(root, cmgr, children[j]);
                    this.url2compName.put(s.getURL(), (String)root.getChild("component").getAttribute("name"));
                    this.url2tstamp.put(s.getURL(), new Timestamp(s.lastModified()));
                }
                componentURLs.add(s.getURL());
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"\u5220\u9664\u7ec4\u4ef6\u5f00\u59cb");
        }
        Iterator iterator = this.url2compName.keySet().iterator();
        while (iterator.hasNext()) {
            URL componentURL = (URL)iterator.next();
            if (componentURLs.contains(componentURL)) continue;
            cmgr.removeComponent((String)this.url2compName.get(componentURL));
            this.url2tstamp.remove(componentURL);
            this.url2compName.remove(componentURL);
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug((Object)("\u5220\u9664\u7684\u7ec4\u4ef6URL=[" + componentURL + "]"));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"\u5220\u9664\u7ec4\u4ef6\u7ed3\u675f");
        }
        Thread.currentThread().setContextClassLoader(cl_old);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"------\u7ec4\u4ef6\u914d\u7f6e\u6587\u4ef6\u68c0\u67e5\u7ed3\u675f");
        }
    }

    private CommonData loadXML(Source s) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"\u88c5\u8f7dXML\u6587\u4ef6\u5f00\u59cb");
        }
        XMLCommonData root = new XMLCommonData();
        try {
            XMLoader.load((CommonData)root, s.getInputStream());
        }
        catch (IOException e) {
            IllegalStateException is = new IllegalStateException("GetInputStream error, source: " + s.toString() + "\n" + e.getMessage());
            throw is;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("\u88c5\u8f7dXML\u6587\u4ef6\u6210\u529f\uff0cURL=[" + s + "]"));
        }
        return root;
    }

    private void addComponent(CommonData root, ComponentManager cmgr, File current) {
        String loaderType = (String)root.getChild("component").getChild("loader").getChild("update-manner").getAttribute("name");
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("\u7ec4\u4ef6\u88c5\u8f7d\u5668\u7c7b\u578b=[" + loaderType + "]"));
        }
        StringBuffer path = new StringBuffer();
        if (root.getChild("component").getChild("loader").getChild("path") == null) {
            path.append(current.getAbsolutePath()).append(File.pathSeparatorChar).append(current.getAbsolutePath() + File.separator + "class").append(File.pathSeparatorChar).append(ComponentMonitorImpl.getPath(current.getAbsolutePath() + File.separator + "lib"));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("\u7ec4\u4ef6\u88c5\u8f7d\u9ed8\u8ba4\u8def\u5f84=[" + path + "]"));
            }
        } else {
            for (int childIndex = 0; childIndex < root.getChild("component").getChild("loader").getChild("path").childCount(); ++childIndex) {
                String tempPath = (String)root.getChild("component").getChild("loader").getChild("path").getChild(childIndex).getValue();
                File dir = current;
                boolean absolute = true;
                while (tempPath.length() >= 1 && tempPath.substring(0, 1).equals(".")) {
                    absolute = false;
                    if (tempPath.substring(0, 2).equals("..")) {
                        tempPath = tempPath.substring(3);
                        dir = dir.getParentFile();
                        continue;
                    }
                    tempPath = tempPath.substring(2);
                }
                if (absolute) {
                    path.append(tempPath);
                } else {
                    path.append(dir.getAbsolutePath() + File.separator + tempPath);
                }
                path.append(File.pathSeparatorChar);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("\u914d\u7f6e\u4e2d\u6307\u5b9a\u7ec4\u4ef6\u88c5\u8f7d\u8def\u5f84=[" + path + "]"));
            }
        }
        AbstractComponentLoader loader = null;
        if (root.getChild("component").getChild("loader").getChild("default-entry") != null) {
            String rule = (String)root.getChild("component").getChild("loader").getChild("default-entry").getChild("rule").getValue();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("\u7ec4\u4ef6\u88c5\u8f7d\u914d\u7f6e\u89c4\u5219=[" + rule + "]"));
            }
            String config = (String)root.getChild("component").getChild("loader").getChild("default-entry").getChild("conf").getValue();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("\u7ec4\u4ef6\u88c5\u8f7d\u914d\u7f6e=[" + rule + "]"));
            }
            if (loaderType.equals("VaryReload")) {
                loader = new VaryComponentLoader(path.toString(), rule, config);
            } else if (loaderType.equals("TimerReload")) {
                loader = new TimerComponentLoader(path.toString(), rule, config);
            } else if (loaderType.equals("ConsoleReload")) {
                loader = new ConsoleComponentLoader(path.toString(), rule, config, (String)root.getChild("component").getAttribute("name"));
            } else if (loaderType.equals("NeverReload")) {
                loader = new UnreloadableComponentLoader(path.toString(), rule, config);
            }
        } else if (root.getChild("component").getChild("loader").getChild("class-entry") != null) {
            String clazz = (String)root.getChild("component").getChild("loader").getChild("class-entry").getAttribute("class");
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("\u7ec4\u4ef6\u88c5\u8f7d\u7c7b=[" + clazz + "]"));
            }
            if (loaderType.equals("VaryReload")) {
                loader = new VaryComponentLoader(path.toString(), clazz);
            } else if (loaderType.equals("TimerReload")) {
                loader = new TimerComponentLoader(path.toString(), clazz);
            } else if (loaderType.equals("ConsoleReload")) {
                loader = new ConsoleComponentLoader(path.toString(), clazz, (String)root.getChild("component").getAttribute("name"));
            } else if (loaderType.equals("NeverReload")) {
                loader = new UnreloadableComponentLoader(path.toString(), clazz);
            }
        }
        String compName = (String)root.getChild("component").getAttribute("name");
        try {
            CommonData descCD;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"\u7ec4\u4ef6\u88c5\u8f7d\u5f00\u59cb");
            }
            String desc = (descCD = root.getChild("component").getChild("desc")) == null ? "" : (String)descCD.getValue();
            cmgr.addComponent(compName, new Class[]{Class.forName((String)root.getChild("component").getChild("type").getValue(), true, this.cl)}, desc, loader);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("\u7ec4\u4ef6 [" + compName + "] \u88c5\u8f7d\u6210\u529f"));
            }
        }
        catch (ClassNotFoundException e) {
            IllegalStateException is = new IllegalStateException("ClassNotFound! ClassName: " + (String)root.getChild("component").getChild("type").getValue() + "\n" + e.getMessage());
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("\u7ec4\u4ef6 [" + compName + "] \u88c5\u8f7d\u5931\u8d25"), (Throwable)is);
            }
            throw is;
        }
    }

    private static String getPath(String lib) {
        StringBuffer path = new StringBuffer();
        File lib_dir = new File(lib);
        if (lib_dir.exists()) {
            File[] jars = lib_dir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar");
                }
            });
            for (int i = 0; i < jars.length; ++i) {
                path.append(jars[i].getAbsoluteFile()).append(File.pathSeparatorChar);
            }
        }
        return path.toString();
    }
}

