/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.load;

import com.dc.eai.component.ComponentManager;
import com.dc.eai.component.ComponentManagerGetter;
import com.dc.eai.load.AbstractComponentLoader;
import com.dc.eai.load.impl.ConsoleComponentLoader;
import com.dc.eai.load.impl.TimerComponentLoader;
import com.dc.eai.load.impl.UnreloadableComponentLoader;
import com.dc.eai.load.impl.VaryComponentLoader;
import com.dc.eai.startup.Bootstrap;
import com.dc.util.classloader.PathClassFinder;
import com.dc.util.classloader.Source;
import com.dc.util.xml.CommonData;
import com.dc.util.xml.XMLCommonData;
import com.dc.util.xml.store.XMLoader;
import com.dc.xml.binding.Utilities;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoadComponent {
    private static Log log = LogFactory.getLog((Class)LoadComponent.class);
    private ComponentManager cmgr = ComponentManagerGetter.getManager();

    public void removeComponent(String ComponentName) {
        if (this.hasCacheComponent(ComponentName)) {
            this.removeCacheComponent(ComponentName);
        }
        if (this.hasCacheMetaData(ComponentName)) {
            this.removeCacheMetaData(ComponentName);
        }
        this.cmgr.removeComponent(ComponentName);
    }

    public boolean hasLoadComponent(String ComponentName) {
        return this.cmgr.containsComponent(ComponentName);
    }

    public int getLoadComSize() {
        return this.cmgr.getAllNames().length;
    }

    public void loadComponent(String foldername) throws Exception {
        List list = (List)Utilities.get("urn:obj:sys:application-paths");
        ClassLoader cl_old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(Bootstrap.getComponentSharedLoader());
        for (int i = 0; i < list.size(); ++i) {
            File f = null;
            f = new File(new URL((String)list.get(i) + "\\" + foldername).getFile());
            if (!f.exists()) continue;
            Source s = new PathClassFinder(f.getAbsolutePath()).getSource("component.xml");
            CommonData root = this.loadXML(s);
            String comName = (String)root.getChild("component").getAttribute("name");
            if (this.hasCacheComponent(comName)) {
                this.removeCacheComponent(comName);
            }
            if (this.hasCacheMetaData(comName)) {
                this.removeCacheMetaData(comName);
            }
            if (s != null) {
                this.cmgr.removeComponent(comName);
                this.addComponent(root, this.cmgr, f);
                continue;
            }
            this.addComponent(root, this.cmgr, f);
        }
        Thread.currentThread().setContextClassLoader(cl_old);
    }

    private CommonData loadXML(Source s) {
        XMLCommonData root = new XMLCommonData();
        try {
            XMLoader.load((CommonData)root, s.getInputStream());
        }
        catch (IOException e) {
            IllegalStateException is = new IllegalStateException("GetInputStream error, source: " + s.toString() + "\n" + e.getMessage());
            throw is;
        }
        return root;
    }

    public void removeCacheMetaData(Object name) {
        Map h = (Map)this.cmgr.getCacheMetaData();
        h.remove(name);
    }

    public void removeCacheProxy(Object name) {
        Map h = (Map)this.cmgr.getCacheProxy();
        h.remove(name);
    }

    public void removeCacheComponent(Object name) {
        Map h = (Map)this.cmgr.getCacheComponent();
        h.remove(name);
    }

    public boolean hasCacheProxy(Object name) {
        Map h = (Map)this.cmgr.getCacheProxy();
        return h.containsKey(name);
    }

    public boolean hasCacheComponent(Object name) {
        Map h = (Map)this.cmgr.getCacheComponent();
        return h.containsKey(name);
    }

    public boolean hasCacheMetaData(Object name) {
        Map h = (Map)this.cmgr.getCacheMetaData();
        return h.containsKey(name);
    }

    private void addComponent(CommonData root, ComponentManager cmgr, File current) {
        String loaderType = (String)root.getChild("component").getChild("loader").getChild("update-manner").getAttribute("name");
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u7ec4\u4ef6\u88c5\u8f7d\u5668\u7c7b\u578b=[" + loaderType + "]"));
        }
        StringBuffer path = new StringBuffer();
        if (root.getChild("component").getChild("loader").getChild("path") == null) {
            path.append(current.getAbsolutePath()).append(File.pathSeparatorChar).append(current.getAbsolutePath() + File.separator + "class").append(File.pathSeparatorChar).append(LoadComponent.getPath(current.getAbsolutePath() + File.separator + "lib"));
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u7ec4\u4ef6\u88c5\u8f7d\u9ed8\u8ba4\u8def\u5f84=[" + path + "]"));
            }
        } else {
            for (int childIndex = 0; childIndex < root.getChild("component").getChild("loader").getChild("path").childCount(); ++childIndex) {
                String tempPath = (String)root.getChild("component").getChild("loader").getChild("path").getChild(childIndex).getValue();
                File dir = current;
                boolean absolute = true;
                while (tempPath.length() >= 1 && tempPath.substring(0, 1).equals(".")) {
                    absolute = false;
                    if (tempPath.substring(0, 2).equals("..")) {
                        tempPath = tempPath.substring(3);
                        dir = dir.getParentFile();
                        continue;
                    }
                    tempPath = tempPath.substring(2);
                }
                if (absolute) {
                    path.append(tempPath);
                } else {
                    path.append(dir.getAbsolutePath() + File.separator + tempPath);
                }
                path.append(File.pathSeparatorChar);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u914d\u7f6e\u4e2d\u6307\u5b9a\u7ec4\u4ef6\u88c5\u8f7d\u8def\u5f84=[" + path + "]"));
            }
        }
        AbstractComponentLoader loader = null;
        if (root.getChild("component").getChild("loader").getChild("default-entry") != null) {
            String rule = (String)root.getChild("component").getChild("loader").getChild("default-entry").getChild("rule").getValue();
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u7ec4\u4ef6\u88c5\u8f7d\u914d\u7f6e\u89c4\u5219=[" + rule + "]"));
            }
            String config = (String)root.getChild("component").getChild("loader").getChild("default-entry").getChild("conf").getValue();
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u7ec4\u4ef6\u88c5\u8f7d\u914d\u7f6e=[" + rule + "]"));
            }
            if (loaderType.equals("VaryReload")) {
                loader = new VaryComponentLoader(path.toString(), rule, config);
            } else if (loaderType.equals("TimerReload")) {
                loader = new TimerComponentLoader(path.toString(), rule, config);
            } else if (loaderType.equals("ConsoleReload")) {
                loader = new ConsoleComponentLoader(path.toString(), rule, config, (String)root.getChild("component").getAttribute("name"));
            } else if (loaderType.equals("NeverReload")) {
                loader = new UnreloadableComponentLoader(path.toString(), rule, config);
            }
        } else if (root.getChild("component").getChild("loader").getChild("class-entry") != null) {
            String clazz = (String)root.getChild("component").getChild("loader").getChild("class-entry").getAttribute("class");
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u7ec4\u4ef6\u88c5\u8f7d\u7c7b=[" + clazz + "]"));
            }
            if (loaderType.equals("VaryReload")) {
                loader = new VaryComponentLoader(path.toString(), clazz);
            } else if (loaderType.equals("TimerReload")) {
                loader = new TimerComponentLoader(path.toString(), clazz);
            } else if (loaderType.equals("ConsoleReload")) {
                loader = new ConsoleComponentLoader(path.toString(), clazz, (String)root.getChild("component").getAttribute("name"));
            } else if (loaderType.equals("NeverReload")) {
                loader = new UnreloadableComponentLoader(path.toString(), clazz);
            }
        }
        String compName = (String)root.getChild("component").getAttribute("name");
        try {
            CommonData descCD;
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u7ec4\u4ef6\u88c5\u8f7d\u5f00\u59cb");
            }
            String desc = (descCD = root.getChild("component").getChild("desc")) == null ? "" : (String)descCD.getValue();
            cmgr.addComponent(compName, new Class[]{Class.forName((String)root.getChild("component").getChild("type").getValue(), true, Bootstrap.getComponentSharedLoader())}, desc, loader);
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u7ec4\u4ef6 [" + compName + "] \u88c5\u8f7d\u6210\u529f"));
            }
        }
        catch (ClassNotFoundException e) {
            IllegalStateException is = new IllegalStateException("ClassNotFound! ClassName: " + (String)root.getChild("component").getChild("type").getValue() + "\n" + e.getMessage());
            if (log.isErrorEnabled()) {
                log.error((Object)("\u7ec4\u4ef6 [" + compName + "] \u88c5\u8f7d\u5931\u8d25"), (Throwable)is);
            }
            throw is;
        }
    }

    private static String getPath(String lib) {
        StringBuffer path = new StringBuffer();
        File lib_dir = new File(lib);
        if (lib_dir.exists()) {
            File[] jars = lib_dir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar");
                }
            });
            for (int i = 0; i < jars.length; ++i) {
                path.append(jars[i].getAbsoluteFile()).append(File.pathSeparatorChar);
            }
        }
        return path.toString();
    }
}

