/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.load;

import com.dc.eai.load.StandardClassLoader;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;

public final class ClassLoaderFactory {
    private static int debug = 0;

    public static int getDebug() {
        return debug;
    }

    public static void setDebug(int newDebug) {
        debug = newDebug;
    }

    public static ClassLoader createClassLoader(File[] unpacked, File[] packed, ClassLoader parent) throws Exception {
        int i;
        if (debug >= 1) {
            ClassLoaderFactory.log("Creating new class loader");
        }
        ArrayList<String> list = new ArrayList<String>();
        if (unpacked != null) {
            for (i = 0; i < unpacked.length; ++i) {
                File file = unpacked[i];
                if (!file.isDirectory() || !file.exists() || !file.canRead()) continue;
                if (debug >= 1) {
                    ClassLoaderFactory.log("  Including directory " + file.getAbsolutePath());
                }
                URL url = new URL("file", null, file.getCanonicalPath() + File.separator);
                list.add(url.toString());
            }
        }
        if (packed != null) {
            for (i = 0; i < packed.length; ++i) {
                File directory = packed[i];
                if (!directory.isDirectory() || !directory.exists() || !directory.canRead()) continue;
                String[] filenames = directory.list();
                for (int j = 0; j < filenames.length; ++j) {
                    String filename = filenames[j].toLowerCase();
                    if (!filename.endsWith(".jar")) continue;
                    File file = new File(directory, filenames[j]);
                    if (debug >= 1) {
                        ClassLoaderFactory.log("  Including jar file " + file.getAbsolutePath());
                    }
                    URL url = new URL("file", null, file.getCanonicalPath());
                    list.add(url.toString());
                }
            }
        }
        String[] array = list.toArray(new String[list.size()]);
        StandardClassLoader classLoader = null;
        classLoader = parent == null ? new StandardClassLoader(array) : new StandardClassLoader(array, parent);
        classLoader.setDelegate(true);
        return classLoader;
    }

    private static void log(String message) {
        System.out.print("ClassLoaderFactory:  ");
        System.out.println(message);
    }

    private static void log(String message, Throwable exception) {
        ClassLoaderFactory.log(message);
        exception.printStackTrace(System.out);
    }
}

