/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.load;

import com.dc.eai.component.Loader;
import com.dc.eai.load.ComponentLoader;
import com.dc.eai.load.XMLLoader;
import com.dc.util.classloader.ChangeAwareClassLoader;
import com.dc.util.classloader.PathClassFinder;

public abstract class AbstractComponentLoader
implements ComponentLoader {
    protected ChangeAwareClassLoader clzLoader;
    protected String path;
    protected String rule;
    protected String config;
    protected String loaderImplClazz;
    protected ClassLoader parent;

    protected AbstractComponentLoader(String path, String rule, String config) {
        this.path = path;
        this.rule = rule;
        this.config = config;
        this.updateClassLoader();
    }

    protected AbstractComponentLoader(String path, String clazz) {
        this.path = path;
        this.loaderImplClazz = clazz;
        this.updateClassLoader();
    }

    protected void updateClassLoader() {
        if (this.parent == null) {
            this.parent = Thread.currentThread().getContextClassLoader();
        }
        PathClassFinder finder = new PathClassFinder(this.path);
        this.clzLoader = new ChangeAwareClassLoader(finder, this.parent);
        this.clzLoader.setDelegate(true);
    }

    public void updateClassLoader(ClassLoader parent) {
        this.parent = parent;
        this.updateClassLoader();
    }

    public Object loadComponent() {
        if (!this.clzLoader.upToDate()) {
            this.updateClassLoader();
        }
        Loader loader = null;
        if (this.loaderImplClazz != null) {
            try {
                ClassLoader oldcl = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.clzLoader);
                loader = (Loader)Class.forName(this.loaderImplClazz, true, this.clzLoader).newInstance();
                Object o = loader.load();
                Thread.currentThread().setContextClassLoader(oldcl);
                return o;
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            loader = new XMLLoader(this.clzLoader.getResource(this.rule), this.clzLoader.getResource(this.config), this.clzLoader);
        }
        return loader.load();
    }
}

