/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.integrtest.special;

import com.dc.eai.config.PackageConfig;
import com.dc.eai.config.ServerConfig;
import com.dc.eai.conv.InputPacket;
import com.dc.eai.conv.OutputPacket;
import com.dc.eai.conv.PackageConverter;
import com.dc.eai.conv.PackageModeFactory;
import com.dc.eai.data.CompositeData;
import com.dc.eai.data.Field;
import com.dc.eai.integrtest.special.TraditionalServerProcess;
import com.dc.eai.server.ServerException;
import com.dc.eai.server.traditional.ServerSpecialProcess;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TellerTraditionalServerProcess
implements ServerSpecialProcess {
    private static Log log = LogFactory.getLog((Class)TraditionalServerProcess.class);
    private ServerConfig config;

    public void setConfig(ServerConfig config) {
        this.config = config;
    }

    public static void main(String[] args) {
    }

    public void beforePack(OutputPacket packet, CompositeData data) {
        PackageConfig pc = this.config.getRequestHeader();
        String mode = pc.getPackageMode();
        PackageModeFactory factory = PackageModeFactory.getFactory();
        try {
            PackageConverter converter = factory.getPackageMode(mode);
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u4f20\u7edf\u670d\u52a1\u7cfb\u7edf\u7ec4\u62a5\u6587\u5934\u5f00\u59cb");
            }
            converter.pack(packet, data, pc.getIOConfig());
        }
        catch (Exception e) {
            ServerException ce = new ServerException(this.config.getName(), e);
            if (log.isErrorEnabled()) {
                log.error((Object)"\u4f20\u7edf\u670d\u52a1\u7cfb\u7edf\u7ec4\u62a5\u6587\u5934\u5931\u8d25!", (Throwable)e);
            }
            throw ce;
        }
    }

    public byte[] beforeSendRequest(byte[] data) {
        return data;
    }

    public byte[] afterRecvResponse(byte[] data) {
        return data;
    }

    public void beforeUnpack(InputPacket packet, CompositeData data) {
        PackageConfig pc = this.config.getResponseHeader();
        String mode = pc.getPackageMode();
        PackageModeFactory factory = PackageModeFactory.getFactory();
        try {
            PackageConverter converter = factory.getPackageMode(mode);
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u4f20\u7edf\u670d\u52a1\u7cfb\u7edf\u62c6\u62a5\u6587\u5934\u5f00\u59cb");
            }
            converter.unpack(packet, data, pc.getIOConfig());
        }
        catch (Exception e) {
            ServerException ce = new ServerException(this.config.getName(), e);
            if (log.isErrorEnabled()) {
                log.error((Object)"\u4f20\u7edf\u670d\u52a1\u7cfb\u7edf\u62c6\u62a5\u6587\u5934\u5931\u8d25!", (Throwable)e);
            }
            throw ce;
        }
    }

    public boolean isSuccess(byte[] buff, CompositeData data) {
        String status = "";
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u4f20\u7edf\u670d\u52a1\u7cfb\u7edf\u7279\u6b8a\u5904\u7406\uff1a\u670d\u52a1\u72b6\u6001\u8bc6\u522b\u5f00\u59cb");
        }
        Field fld = data.getField("msgid");
        status = fld.strValue();
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u4f20\u7edf\u670d\u52a1\u7cfb\u7edf\u7279\u6b8a\u5904\u7406\uff1a\u670d\u52a1\u72b6\u6001\u8bc6\u522b\u7ed3\u675fmsgid[" + status + "]"));
        }
        return "    0".equals(status);
    }
}

