/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.errorcode;

import com.dc.eai.data.CompositeData;
import com.dc.eai.data.Field;
import com.dc.eai.data.FieldAttr;
import com.dc.eai.data.FieldType;
import com.dc.eai.errorcode.ErrorConstants;

public class ErrorCodeProcessor {
    private static String DATA_ERROR = "F3002";
    private static String TRAN_FAIL = "F3101";
    private static String TRAN_UNKNOWN_STATUS = "F3102";
    private static String UNKNOWN_STATUS = "F9003";
    private static String SEQUENTIAL_ERROR = "F3108";
    private static String DATA_ERROR_MSG = "\u6570\u636e\u5305\u9519\u8bef";
    private static String TRAN_FAIL_MSG = "\u4ea4\u6613\u8bf7\u6c42\u5931\u8d25";
    private static String TRAN_UNKNOWN_STATUS_MSG = "\u4ea4\u6613\u5f85\u67e5";
    private static String UNKNOWN_STATUS_MSG = "\u672a\u77e5\u72b6\u6001";
    private static String SEQUENTIAL_ERROR_MSG = "\u4ea4\u6613\u65f6\u5e8f\u9519\u8bef";

    public static void addErrorCode(String errCode, String errMsg, CompositeData data) {
        Field errFld = new Field(new FieldAttr(FieldType.FIELD_STRING, ErrorConstants.ERROR_CODE_LENGTH));
        Field errMsgFld = new Field(new FieldAttr(FieldType.FIELD_STRING, ErrorConstants.ERROR_MSG_LENGTH));
        data.addField(ErrorConstants.ERROR_CODE, errFld);
        data.addField(ErrorConstants.ERROR_MSG, errMsgFld);
        if (errCode.equals("system.channel.illegal_request_data") || errCode.equals("system.channel.data_convert_error") || errCode.equals("system.tran.data_convert_error")) {
            errFld.setValue(DATA_ERROR);
            errMsgFld.setValue(DATA_ERROR_MSG);
        } else if (errCode.equals("system.dispatch_service_not_found") || errCode.equals("system.dispatch_channel_not_found") || errCode.equals("system.channel.identify_tran_error") || errCode.equals("system.channel.special_after_recv_request") || errCode.equals("system.channel.special_before_unpack") || errCode.equals("system.channel.special_before_send_request") || errCode.equals("system.channel.special_before_map_in") || errCode.equals("system.tran.get_service_name_error") || errCode.equals("system.tran.special_after_recv_request") || errCode.equals("system.tran.special_before_unpack") || errCode.equals("system.tran.special_before_send_request") || errCode.equals("system.tran.special_before_map_in")) {
            errFld.setValue(TRAN_FAIL);
            errMsgFld.setValue(TRAN_FAIL_MSG);
        } else if (errCode.equals("system.channel.special_before_pack") || errCode.equals("system.channel.special_before_send_response") || errCode.equals("system.channel.special_before_map_out") || errCode.equals("system.channel.special_before_pack_error") || errCode.equals("system.channel.special_before_pack_system_error") || errCode.equals("system.tran.special_before_pack") || errCode.equals("system.tran.special_before_send_response") || errCode.equals("system.tran.special_before_map_out") || errCode.equals("system.tran.special_before_pack_error") || errCode.equals("system.tran.special_before_pack_system_error")) {
            errFld.setValue(TRAN_UNKNOWN_STATUS);
            errMsgFld.setValue(TRAN_UNKNOWN_STATUS_MSG);
        } else if (errCode.equals("system.service.sequential_error")) {
            errFld.setValue(SEQUENTIAL_ERROR);
            errMsgFld.setValue(SEQUENTIAL_ERROR_MSG);
        } else {
            errFld.setValue(UNKNOWN_STATUS);
            errMsgFld.setValue(UNKNOWN_STATUS_MSG);
        }
    }
}

