/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.entry.rmi;

import com.dc.eai.component.ComponentManagerGetter;
import com.dc.eai.data.CompositeData;
import com.dc.eai.entry.rmi.EntryConfig;
import com.dc.eai.entry.rmi.RegistryUtil;
import com.dc.eai.entry.rmi.ServiceEntry;
import com.dc.eai.service.Service;
import com.dc.eai.service.ServiceResult;
import com.dc.exception.SystemException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServiceEntryImpl
extends UnicastRemoteObject
implements ServiceEntry {
    EntryConfig config = null;
    private static Log log = LogFactory.getLog((Class)ServiceEntryImpl.class);

    public ServiceEntryImpl(EntryConfig config) throws RemoteException {
        this.config = config;
        this.start();
    }

    public void start() {
        if (log.isInfoEnabled()) {
            log.info((Object)("\u5f00\u59cb\u542f\u52a8\u670d\u52a1\u63a5\u5165\u7ec4\u4ef6\uff1a" + this.config));
        }
        RegistryUtil.getInstance().bind(this);
        log.info((Object)"\u542f\u52a8\u670d\u52a1\u63a5\u5165\u7ec4\u4ef6\u7ed3\u675f.");
    }

    public ServiceResult execute(CompositeData request) throws RemoteException {
        if (log.isInfoEnabled()) {
            log.info((Object)"\u670d\u52a1\u63a5\u5165\u5f00\u59cb\u6267\u884c.");
            log.info((Object)("\u8bf7\u6c42\u6570\u636e\u4e3a:" + request));
            log.info((Object)("\u83b7\u53d6\u670d\u52a1\u7ec4\u4ef6\uff1a" + this.config.getServiceName()));
        }
        try {
            ServiceResult ret;
            block7: {
                Service realService = (Service)ComponentManagerGetter.getManager().getComponent(this.config.getServiceName());
                if (log.isInfoEnabled()) {
                    log.info((Object)"\u670d\u52a1\u5f00\u59cb\u6267\u884c.");
                }
                ret = null;
                try {
                    ret = realService.execute(request);
                }
                catch (Exception e) {
                    if (!log.isErrorEnabled()) break block7;
                    log.error((Object)"\u670d\u52a1\u63a5\u5165\u6267\u884c\u670d\u52a1\u5f02\u5e38\uff1a", (Throwable)e);
                }
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("\u670d\u52a1\u7ed3\u679c\u4e3a\uff1a" + ret));
                log.info((Object)"\u670d\u52a1\u6267\u884c\u7ed3\u675f.");
            }
            return ret;
        }
        catch (Exception e) {
            log.error((Object)"\u670d\u52a1\u63a5\u5165\u4e2d\u670d\u52a1\u6267\u884c\u5f02\u5e38\uff1a", (Throwable)e);
            throw new SystemException("\u670d\u52a1\u63a5\u5165\u4e2d\u670d\u52a1\u6267\u884c\u5f02\u5e38", e);
        }
    }

    public EntryConfig getConfig() {
        return this.config;
    }
}

