/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.entry.rmi;

import com.dc.eai.entry.rmi.EntryConfig;
import com.dc.eai.entry.rmi.ServiceEntry;
import java.rmi.RMISecurityManager;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RegistryUtil {
    private static RegistryUtil registry = new RegistryUtil();
    private Map regPool = new HashMap();
    private static Log log = LogFactory.getLog((Class)RegistryUtil.class);

    private RegistryUtil() {
        this.setSecurityManager();
    }

    public static RegistryUtil getInstance() {
        return registry;
    }

    private void setSecurityManager() {
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm == null) {
                System.setSecurityManager(new RMISecurityManager());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void bind(ServiceEntry entry) {
        try {
            if (log.isInfoEnabled()) {
                log.info((Object)("\u6ce8\u518c\u670d\u52a1\u63a5\u5165\u7ec4\u4ef6:" + entry.getConfig()));
            }
            Registry registry = this.getRegistry(entry.getConfig().getPort());
            String url = this.getURL(entry.getConfig());
            registry.rebind(url, entry);
            if (log.isInfoEnabled()) {
                log.info((Object)"\u6ce8\u518c\u670d\u52a1\u63a5\u5165\u7ec4\u4ef6\u6ce8\u518c\u6210\u529f.");
            }
        }
        catch (Exception e) {
            log.error((Object)"\u6ce8\u518c\u670d\u52a1\u63a5\u5165\u7ec4\u4ef6\u5f02\u5e38", (Throwable)e);
        }
    }

    private synchronized Registry getRegistry(String port) {
        Registry registry;
        if (port == null || port.trim().equals("")) {
            port = "1099";
        }
        if ((registry = (Registry)this.regPool.get(port)) == null) {
            try {
                registry = LocateRegistry.createRegistry(Integer.parseInt(port));
                this.regPool.put(port, registry);
            }
            catch (Exception e) {
                log.error((Object)"\u83b7\u53d6\u6ce8\u518c\u5668\u5f02\u5e38", (Throwable)e);
            }
        }
        return registry;
    }

    private String getURL(EntryConfig config) {
        String host = config.getHost();
        String port = config.getPort();
        String jndiName = config.getJndiName();
        jndiName = jndiName == null || jndiName.trim().equals("") ? config.getServiceName() : jndiName;
        String url = "rmi://" + host + ":" + port + "/" + jndiName;
        return url;
    }
}

