/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.entry.http;

import com.dc.eai.data.CompositeData;
import com.dc.eai.entry.ServiceEntrySpecialProcess;
import com.dc.eai.entry.ServiceEntrySpecialProcessException;
import com.dc.eai.entry.http.HTTPException;
import com.dc.eai.service.ServiceResult;
import com.dc.eai.startup.Bootstrap;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServiceHttpEntry
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getLog((Class)ServiceHttpEntry.class);
    private ServiceEntrySpecialProcess specialProcess = null;

    public void init() {
        ServletConfig config = this.getServletConfig();
        String special = config.getInitParameter("Special");
        Object specialObject = null;
        try {
            specialObject = Class.forName(special).newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        this.specialProcess = specialObject;
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        Object data = null;
        Object changedData = null;
        CompositeData cd = null;
        ServiceResult result = null;
        String serviceName = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u8fdc\u7a0b\u670d\u52a1\u63a5\u5165\uff0c\u63a5\u6536\u6570\u636e..");
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u8fdc\u7a0b\u670d\u52a1\u63a5\u6536\u6570\u636e\u5f00\u59cb..");
            }
            data = this.readContent(request);
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u8fdc\u7a0b\u670d\u52a1\u63a5\u6536\u6570\u636e\u540e\u7684\u7279\u6b8a\u5904\u7406\u5f00\u59cb..");
            }
            changedData = this.specialProcess.afterRecvRequest(data);
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u8fdc\u7a0b\u670d\u52a1\u5411\u670d\u52a1\u53d1\u9001\u524d\u7684\u7279\u6b8a\u5904\u7406\u5f00\u59cb..");
            }
            cd = this.specialProcess.beforeSendRequest(changedData);
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u8fdc\u7a0b\u670d\u52a1\u63a5\u6536\u6570\u636e\u540e\u670d\u52a1\u8bc6\u522b\u5f00\u59cb..");
            }
            serviceName = this.specialProcess.getServiceName(data, cd);
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u8fdc\u7a0b\u670d\u52a1\u6267\u884c\u5f00\u59cb..");
            }
            result = this.execute(cd, serviceName);
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u670d\u52a1\u6267\u884c\u72b6\u6001\uff1a" + result.status()));
                log.debug((Object)("\u670d\u52a1\u6267\u884c\u7ed3\u679c\u6570\u636e\uff1a" + result.getOutput()));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u8fdc\u7a0b\u670d\u52a1\u5f97\u5230\u670d\u52a1\u7ed3\u679c\u540e\u7684\u7279\u6b8a\u5904\u7406\u5f00\u59cb..");
            }
            data = this.specialProcess.afterRecvResponse(result);
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u8fdc\u7a0b\u670d\u52a1\u5411\u8fd4\u56de\u524d\u7684\u7279\u6b8a\u5904\u7406\u5f00\u59cb..");
            }
            data = this.specialProcess.beforeSendResponse(data);
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u8fdc\u7a0b\u670d\u52a1\u8fd4\u56de\u6570\u636e\u5f00\u59cb..");
            }
            this.writeContent(response, data);
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u8fdc\u7a0b\u670d\u52a1\u7ed3\u675f..");
            }
        }
        catch (HTTPException e) {
            e.printStackTrace();
        }
        catch (ServiceEntrySpecialProcessException e) {
            e.printStackTrace();
        }
    }

    private ServiceResult execute(CompositeData cd, String serviceName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u4ece\u5bb9\u5668\u4e2d\u83b7\u53d6\u670d\u52a1\u7ec4\u4ef6[" + serviceName + "]"));
        }
        Object service = this.getService(serviceName);
        Object serviceResult = null;
        try {
            serviceResult = service.getClass().getMethod("execute", CompositeData.class).invoke(service, (Object[])new CompositeData[]{cd});
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return (ServiceResult)serviceResult;
    }

    private Object getService(String serviceName) {
        Class<?> cmgetter = null;
        try {
            cmgetter = Bootstrap.getCommonLoader().loadClass("com.dc.eai.component.ComponentManagerGetter");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        Object cmo = null;
        try {
            cmo = cmgetter.getMethod("getManager", null).invoke(null, null);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        Class<?> cm = null;
        try {
            cm = Bootstrap.getCommonLoader().loadClass("com.dc.eai.component.ComponentManager");
        }
        catch (ClassNotFoundException e2) {
            e2.printStackTrace();
        }
        Object svrcmp = null;
        try {
            svrcmp = cm.getMethod("getComponent", String.class).invoke(cmo, serviceName);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return svrcmp;
    }

    private Object readContent(HttpServletRequest request) {
        Object o = null;
        ServletInputStream input = null;
        ObjectInputStream ois = null;
        try {
            input = request.getInputStream();
        }
        catch (IOException e) {
            HTTPException he = new HTTPException("GetInputStream Error", e);
            he.addScene("request", request);
            throw he;
        }
        try {
            ois = new ObjectInputStream((InputStream)input);
            o = ois.readObject();
            ois.close();
        }
        catch (ClassNotFoundException e) {
            HTTPException he = new HTTPException("FoundClass Error", e);
            he.addScene("Object", o);
            throw he;
        }
        catch (IOException e) {
            HTTPException he = new HTTPException("ReadInput Error", e);
            he.addScene("InputStream", ois);
            throw he;
        }
        return o;
    }

    private void writeContent(HttpServletResponse response, Object data) {
        ServletOutputStream os = null;
        ObjectOutputStream objout = null;
        try {
            os = response.getOutputStream();
        }
        catch (IOException e) {
            HTTPException he = new HTTPException("GetOutputStream Error", e);
            he.addScene("response", response);
            throw he;
        }
        try {
            objout = new ObjectOutputStream((OutputStream)os);
            objout.writeObject(data);
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u6210\u529f\u8fd4\u56de\u54cd\u5e94\uff01");
            }
            os.close();
        }
        catch (IOException e) {
            HTTPException he = new HTTPException("WriteOutput Error", e);
            he.addScene("OutputStream", objout);
            throw he;
        }
    }
}

