/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.entry.client;

import com.dc.eai.data.CompositeData;
import com.dc.eai.entry.client.Service;
import com.dc.eai.entry.rmi.EntryConfig;
import com.dc.eai.entry.rmi.ServiceEntry;
import com.dc.eai.service.ServiceResult;
import com.dc.exception.SystemException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServiceRMIStub
implements Service {
    private EntryConfig config = null;
    private static Log log = LogFactory.getLog((Class)ServiceRMIStub.class);

    public ServiceRMIStub(EntryConfig config) {
        this.config = config;
    }

    public ServiceResult execute(CompositeData request) {
        try {
            ServiceResult result;
            block8: {
                if (log.isInfoEnabled()) {
                    log.info((Object)("\u5f00\u59cb\u6267\u884c\u670d\u52a1Stub:" + this.getName()));
                    log.info((Object)("\u8bf7\u6c42\u6570\u636e\u4e3a\uff1a" + request));
                    log.info((Object)"\u83b7\u53d6\u8fdc\u7a0b\u670d\u52a1\u4ee3\u7406.");
                }
                ServiceEntry proxy = this.getServiceRemoteProxy();
                System.out.println(proxy);
                if (log.isInfoEnabled()) {
                    log.info((Object)"\u5f00\u59cb\u6267\u884c\u8fdc\u7a0b\u4ee3\u7406.");
                }
                result = null;
                try {
                    result = proxy.execute(request);
                }
                catch (Exception e) {
                    if (!log.isErrorEnabled()) break block8;
                    log.error((Object)"\u670d\u52a1\u63a5\u5165\u5f02\u5e38\uff1a", (Throwable)e);
                }
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("\u7ed3\u679c\u4e3a\uff1a" + result));
                log.info((Object)"\u6267\u884c\u8fdc\u7a0b\u4ee3\u7406\u7ed3\u675f.");
            }
            return result;
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"\u6267\u884c\u8fdc\u7a0b\u670d\u52a1\u5931\u8d25\uff1a", (Throwable)e);
            }
            SystemException ex = new SystemException("\u83b7\u53d6\u8fdc\u7a0b\u4ee3\u7406\u51fa\u9519:", e);
            ex.addScene("config:", this.config);
            throw ex;
        }
    }

    private ServiceEntry getServiceRemoteProxy() {
        try {
            int p = Integer.parseInt(this.getPort());
            Registry registry = LocateRegistry.getRegistry(this.config.getHost(), p);
            ServiceEntry proxy = (ServiceEntry)registry.lookup(this.getURL());
            return proxy;
        }
        catch (Exception e) {
            log.error((Object)"\u83b7\u53d6\u8fdc\u7a0b\u670d\u52a1\u4ee3\u7406\u5f02\u5e38\uff1a", (Throwable)e);
            SystemException ex = new SystemException("\u83b7\u53d6\u8fdc\u7a0b\u670d\u52a1\u4ee3\u7406\u5f02\u5e38", e);
            ex.addScene("config:", this.config);
            throw ex;
        }
    }

    private String getURL() {
        String url = "rmi://" + this.config.getHost() + ":" + this.getPort() + "/" + this.getJndiName();
        return url;
    }

    public String getJndiName() {
        String jName = this.config.getJndiName() == null ? this.config.getServiceName() : this.config.getJndiName();
        return jName;
    }

    public String getPort() {
        String p = this.config.getPort() == null ? "1099" : this.config.getPort();
        return p;
    }

    public String getName() {
        return this.config.getServiceName();
    }
}

