/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.entry.client;

import com.dc.eai.config.DataDictionary;
import com.dc.eai.config.DictionaryItem;
import com.dc.eai.data.Field;
import com.dc.eai.data.FieldAttr;
import com.dc.eai.data.FieldType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FieldUtil {
    private Log log = LogFactory.getLog((Class)FieldUtil.class);
    private static FieldUtil util = new FieldUtil();
    private DataDictionary dictionary;

    private FieldUtil() {
    }

    public static FieldUtil getInstance() {
        return util;
    }

    public Field createField(String name, Object value) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("\u521b\u5efa\u4e00\u4e2a\u6570\u636e\u57df | \u540d\u79f0=" + name + " ; \u503c=" + value));
        }
        if (this.dictionary == null || name == null || name.trim().equals("")) {
            return null;
        }
        DictionaryItem item = this.dictionary.getItem(name);
        if (item == null) {
            return null;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"\u6570\u636e\u57df\u5c5e\u6027\uff1a");
            this.log.debug((Object)("length:" + item.getLength()));
            this.log.debug((Object)("scale:" + item.getScale()));
            this.log.debug((Object)("type:" + item.getType()));
        }
        FieldAttr attr = this.convert(item);
        Field field = new Field(attr);
        this.setValue(field, value);
        return field;
    }

    private FieldAttr convert(DictionaryItem item) {
        return new FieldAttr(item.getType(), item.getLength(), item.getScale());
    }

    private void setValue(Field field, Object value) {
        FieldAttr fattr = field.getAttr();
        FieldType ftype = fattr.getType();
        if (FieldType.integerType(ftype)) {
            long l = 0L;
            try {
                l = Long.parseLong(value.toString());
            }
            catch (Exception e) {
                // empty catch block
            }
            field.setValue(new Long(l));
        } else if (FieldType.decimalType(ftype)) {
            double d = 0.0;
            try {
                d = Double.parseDouble(value.toString());
            }
            catch (Exception e) {
                // empty catch block
            }
            field.setValue(new Double(d));
        } else if (ftype == FieldType.FIELD_STRING) {
            field.setValue(value.toString());
        } else if (fattr.getType() == FieldType.FIELD_IMAGE) {
            int length = fattr.getLength();
            System.arraycopy(field.imageValue(), 0, (byte[])value, 0, length);
        }
    }

    private DataDictionary getDictionary() {
        return this.dictionary;
    }

    public void setDictionary(DataDictionary dictionary) {
        this.dictionary = dictionary;
    }
}

