/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.entry.client;

import com.dc.xml.binding.ExtDigesterHelper;
import java.io.File;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BootStrap {
    private static BootStrap bootStrap = new BootStrap();
    private URL eai_Home = null;
    private static Log log = LogFactory.getLog((Class)BootStrap.class);

    private BootStrap() {
    }

    public static BootStrap getInstance() {
        return bootStrap;
    }

    public void load(URL eaiHome) {
        this.initEaiHome(eaiHome);
        this.loadDict();
        this.loadService();
    }

    private void initEaiHome(URL eaiHome) {
        if (log.isInfoEnabled()) {
            log.info((Object)"\u5f00\u59cb\u521d\u59cb\u5316EAI_HOME.");
        }
        this.eai_Home = eaiHome;
        try {
            File dir;
            if (this.eai_Home == null && (dir = new File(System.getProperty("EAI_HOME"))).exists()) {
                this.eai_Home = dir.toURL();
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("EAI_HOME:" + this.eai_Home.getFile()));
                log.info((Object)"\u521d\u59cb\u5316EAI_HOME\u5b8c\u6bd5.");
            }
            return;
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"\u52a0\u8f7dEAI_HOME\u5931\u8d25\uff1a", (Throwable)e);
            }
            throw new NullPointerException("No such a dir:" + System.getProperty("EAI_HOME"));
        }
    }

    private void loadDict() {
        block4: {
            try {
                if (log.isInfoEnabled()) {
                    log.info((Object)"\u5f00\u59cb\u52a0\u8f7d\u6570\u636e\u5b57\u5178.");
                }
                URL rule = this.getURL(this.eai_Home, "rule/dict.rule.xml");
                URL data = this.getURL(this.eai_Home, "global/dict.xml");
                ExtDigesterHelper.load(rule, this.getClass().getClassLoader(), data);
                if (log.isInfoEnabled()) {
                    log.info((Object)"\u52a0\u8f7d\u6570\u636e\u5b57\u5178\u5b8c\u6bd5.");
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)"\u52a0\u8f7d\u6570\u636e\u5b57\u5178\u5931\u8d25\uff1a", (Throwable)e);
            }
        }
    }

    private void loadService() {
        block4: {
            try {
                if (log.isInfoEnabled()) {
                    log.info((Object)"\u5f00\u59cb\u52a0\u8f7d\u670d\u52a1\u63a5\u5165.");
                }
                URL rule = this.getURL(this.eai_Home, "rule/entry.rule.xml");
                URL data = this.getURL(this.eai_Home, "global/entry.xml");
                ExtDigesterHelper.load(rule, this.getClass().getClassLoader(), data);
                if (log.isInfoEnabled()) {
                    log.info((Object)"\u52a0\u8f7d\u670d\u52a1\u63a5\u5165\u5b8c\u6bd5.");
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)"\u52a0\u8f7d\u670d\u52a1\u63a5\u5165\u5931\u8d25\uff1a", (Throwable)e);
            }
        }
    }

    private URL getURL(URL parent, String relativePath) {
        try {
            URL ret = new File(new File(parent.getPath()), relativePath).toURL();
            return ret;
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)("\u83b7\u53d6URL\u51fa\u73b0\u5f02\u5e38\uff1aparent:" + parent + "  relativePath" + relativePath), (Throwable)e);
            }
            return null;
        }
    }

    public static void main(String[] args) {
        try {
            BootStrap bootStrap = BootStrap.getInstance();
            URL url = new URL("file:///E:/work/platform/platform/eai2.0_integration_test/clientconf/");
            bootStrap.load(url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

