/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.entry.api;

import com.dc.eai.data.CompositeData;
import com.dc.eai.entry.api.ServiceInvoke;
import com.dc.eai.service.ServiceResult;
import com.dc.eai.startup.Bootstrap;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServiceInvokeImpl
implements ServiceInvoke {
    private static Log log = LogFactory.getLog((Class)ServiceInvokeImpl.class);

    public ServiceResult execute(String serviceName, CompositeData request) {
        ServiceResult result = null;
        if (("".equals(serviceName) || serviceName == null || request == null) && log.isErrorEnabled()) {
            log.error((Object)"ServiceInvoke:\u8c03\u7528\u670d\u52a1\u7684\u53c2\u6570\u4e0d\u5408\u6cd5!");
        }
        Object service = this.getService(serviceName);
        if (log.isInfoEnabled()) {
            log.info((Object)("ServiceInvoke\uff1a\u5f97\u5230\u7684\u670d\u52a1\u662f[" + service.getClass().getName() + "]"));
        }
        try {
            Method method = service.getClass().getMethod("execute", CompositeData.class);
            if (log.isInfoEnabled()) {
                log.info((Object)("ServiceInvoke\uff1a\u6240\u8981\u8c03\u7528\u7684\u65b9\u6cd5\u662f[" + method.getName() + "]"));
            }
            result = (ServiceResult)method.invoke(service, (Object[])new CompositeData[]{request});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private Object getService(String serviceName) {
        return this.getComponent(serviceName);
    }

    private Object getComponent(String comName) {
        try {
            Class<?> cmgetter = Bootstrap.getCommonLoader().loadClass("com.dc.eai.component.ComponentManagerGetter");
            Object cm_o = cmgetter.getMethod("getManager", null).invoke(null, null);
            Class<?> cm = Bootstrap.getCommonLoader().loadClass("com.dc.eai.component.ComponentManager");
            Object comp_o = cm.getMethod("getComponent", String.class).invoke(cm_o, comName);
            return comp_o;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

