/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.dispatch.passthrough;

import com.dc.eai.adapter.Adapter;
import com.dc.eai.component.ComponentManager;
import com.dc.eai.component.ComponentManagerGetter;
import com.dc.eai.config.PassThroughConfig;
import com.dc.eai.dispatch.Dispatch;
import com.dc.eai.dispatch.DispatchException;
import com.dc.eai.dispatch.passthrough.DefaultSpecialProcess;
import com.dc.eai.dispatch.passthrough.SpecialProcess;
import com.dc.exception.SystemException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PassThroughDispatch
implements Dispatch {
    private SpecialProcess specialProcess = new DefaultSpecialProcess();
    private PassThroughConfig config = null;
    private static Log log = LogFactory.getLog((Class)PassThroughDispatch.class);

    public Object doDispatch(Object data) {
        ComponentManager componentManager;
        boolean hasAdapter;
        Object response = null;
        if (log.isInfoEnabled()) {
            log.info((Object)"\u7a7f\u900f\u8c03\u5ea6\uff1a\u63a5\u53d7\u6570\u636e\u540e\u5904\u7406\u5f00\u59cb");
        }
        Object request = this.specialProcess.afterRecvRequest(data);
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u7a7f\u900f\u8c03\u5ea6\uff1a\u53d1\u9001\u8bf7\u6c42\u524d\u5904\u7406");
        }
        request = this.specialProcess.beforeSendRequest(request);
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u7a7f\u900f\u8c03\u5ea6\uff1a\u83b7\u53d6\u901a\u8baf\u7ec4\u4ef6");
        }
        String adapterName = this.config.getTo();
        if (log.isInfoEnabled()) {
            log.info((Object)("\u7a7f\u900f\u8c03\u5ea6\uff1a\u901a\u8baf\u63a5\u51fa\u7ec4\u4ef6\u540d\u79f0[" + adapterName + "]"));
        }
        if (hasAdapter = (componentManager = ComponentManagerGetter.getManager()).containsComponent(adapterName)) {
            block15: {
                Adapter comm = (Adapter)ComponentManagerGetter.getManager().getComponent(adapterName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"\u7a7f\u900f\u8c03\u5ea6: \u901a\u8baf\u7ec4\u4ef6\u5f00\u59cb\u6267\u884c");
                }
                try {
                    response = comm.doComm(request);
                }
                catch (SystemException se) {
                    se.addScene("adapter_execute_fail", se);
                    if (log.isErrorEnabled()) {
                        log.error((Object)"\u7a7f\u900f\u8c03\u5ea6\uff1a\u901a\u8baf\u7ec4\u4ef6\u6267\u884c\u5931\u8d25", (Throwable)se);
                    }
                }
                catch (Exception e) {
                    if (!log.isErrorEnabled()) break block15;
                    log.error((Object)"\u7a7f\u900f\u8c03\u5ea6\uff1a\u672a\u77e5\u5f02\u5e38", (Throwable)e);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u7a7f\u900f\u8c03\u5ea6\uff1a\u63a5\u53d7\u54cd\u5e94\u6570\u636e\u540e\u5904\u7406");
            }
            response = this.specialProcess.afterRecvResponse(response);
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u7a7f\u900f\u8c03\u5ea6\uff1a\u53d1\u9001\u54cd\u5e94\u6570\u636e\u524d\u5904\u7406");
            }
        } else {
            DispatchException e = new DispatchException(this.config.getName(), "adapter_not_found");
            e.addScene("adapter", adapterName);
            if (log.isErrorEnabled()) {
                log.error((Object)"\u7a7f\u900f\u8c03\u5ea6\u5f02\u5e38\uff1a", (Throwable)e);
            }
            throw e;
        }
        response = this.specialProcess.beforeSendResponse(response);
        if (log.isInfoEnabled()) {
            log.info((Object)("\u7a7f\u900f\u8c03\u5ea6\uff1a" + this.config.getName() + "\u6267\u884c\u7ed3\u675f!"));
        }
        return response;
    }

    public PassThroughConfig getConfig() {
        return this.config;
    }

    public void setConfig(PassThroughConfig config) {
        this.config = config;
    }

    public SpecialProcess getSpecialProcess() {
        return this.specialProcess;
    }

    public void setSpecialProcess(SpecialProcess specialProcess) {
        this.specialProcess = specialProcess;
    }
}

