/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.data;

import com.dc.util.enums.Enum;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class FieldType
extends Enum {
    public static FieldType FIELD_STRING = new FieldType("string");
    public static FieldType FIELD_IMAGE = new FieldType("image");
    public static FieldType FIELD_BYTE = new FieldType("byte");
    public static FieldType FIELD_SHORT = new FieldType("short");
    public static FieldType FIELD_INT24 = new FieldType("int24");
    public static FieldType FIELD_INT = new FieldType("int");
    public static FieldType FIELD_LONG = new FieldType("long");
    public static FieldType FIELD_FLOAT = new FieldType("float");
    public static FieldType FIELD_DOUBLE = new FieldType("double");

    public static boolean integerType(FieldType type) {
        return type == FIELD_LONG || type == FIELD_INT24 || type == FIELD_INT || type == FIELD_SHORT || type == FIELD_BYTE;
    }

    public static boolean decimalType(FieldType type) {
        return type == FIELD_DOUBLE || type == FIELD_FLOAT;
    }

    public static boolean stringType(FieldType type) {
        return type == FIELD_STRING;
    }

    public static boolean numberType(FieldType type) {
        return FieldType.integerType(type) || FieldType.decimalType(type);
    }

    public static FieldType getEnum(String type) {
        return (FieldType)FieldType.getEnum(FieldType.class, type);
    }

    public static Map getEnumMap() {
        return FieldType.getEnumMap(FieldType.class);
    }

    public static List getEnumList() {
        return FieldType.getEnumList(FieldType.class);
    }

    public static Iterator iterator() {
        return FieldType.iterator(FieldType.class);
    }

    private FieldType(String type) {
        super(type);
    }

    public static FieldType getFieldType(String type) {
        if (type.equals("string")) {
            return FIELD_STRING;
        }
        if (type.equals("image")) {
            return FIELD_IMAGE;
        }
        if (type.equals("byte")) {
            return FIELD_BYTE;
        }
        if (type.equals("short")) {
            return FIELD_SHORT;
        }
        if (type.equals("int24")) {
            return FIELD_INT24;
        }
        if (type.equals("int")) {
            return FIELD_INT;
        }
        if (type.equals("long")) {
            return FIELD_LONG;
        }
        if (type.equals("float")) {
            return FIELD_FLOAT;
        }
        if (type.equals("double")) {
            return FIELD_DOUBLE;
        }
        return null;
    }
}

