/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.data;

import com.dc.eai.data.FieldType;
import java.io.Serializable;

public final class FieldAttr
implements Serializable {
    private static final long serialVersionUID = 1L;
    private FieldType type;
    private int length;
    private int scale;
    private boolean pin;

    public FieldAttr(FieldType type, int length) {
        this(type, length, 0);
    }

    public FieldAttr(FieldType type, int length, boolean pin) {
        this(type, length, 0, pin);
    }

    public FieldAttr(FieldType type, int length, int scale) {
        this(type, length, scale, false);
    }

    public FieldAttr(FieldType type, int length, int scale, boolean pin) {
        this.type = type;
        this.length = length;
        this.scale = scale;
        if (!FieldType.decimalType(type) && !FieldType.stringType(type)) {
            this.scale = 0;
        }
        this.pin = pin;
    }

    public FieldType getType() {
        return this.type;
    }

    public int getLength() {
        return this.length;
    }

    public int getScale() {
        return this.scale;
    }

    public boolean getPin() {
        return this.pin;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof FieldAttr)) {
            return false;
        }
        FieldAttr attr = (FieldAttr)obj;
        return this.type == attr.type && this.length == attr.length && this.scale == attr.scale && this.pin == attr.pin;
    }
}

