/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.data;

import com.dc.eai.data.AtomData;
import com.dc.eai.data.FieldAttr;
import com.dc.eai.data.FieldType;
import com.dc.eai.data.UnmatchTypeException;

public class Field
extends AtomData {
    protected FieldAttr attr;
    protected Object value;

    public Field(FieldAttr attr) {
        this.attr = attr;
        this.type = FIELD_TYPE;
    }

    public FieldAttr getAttr() {
        return this.attr;
    }

    public FieldType getFieldType() {
        if (this.attr == null) {
            return null;
        }
        if (this.attr.getType() == null) {
            return null;
        }
        return this.attr.getType();
    }

    public int intValue() {
        if (this.value instanceof Number) {
            return ((Number)this.value).intValue();
        }
        throw this.unmatchRequestType(FieldType.FIELD_INT);
    }

    public long longValue() {
        if (this.value instanceof Number) {
            return ((Number)this.value).longValue();
        }
        throw this.unmatchRequestType(FieldType.FIELD_LONG);
    }

    public float floatValue() {
        if (this.value instanceof Number) {
            return ((Number)this.value).floatValue();
        }
        throw this.unmatchRequestType(FieldType.FIELD_FLOAT);
    }

    public double doubleValue() {
        if (this.value instanceof Number) {
            return ((Number)this.value).doubleValue();
        }
        throw this.unmatchRequestType(FieldType.FIELD_DOUBLE);
    }

    public short shortValue() {
        if (this.value instanceof Number) {
            return ((Number)this.value).shortValue();
        }
        throw this.unmatchRequestType(FieldType.FIELD_SHORT);
    }

    public byte byteValue() {
        if (this.value instanceof Number) {
            return ((Number)this.value).byteValue();
        }
        throw this.unmatchRequestType(FieldType.FIELD_BYTE);
    }

    public String strValue() {
        if (this.value == null) {
            return null;
        }
        if (this.value instanceof String) {
            return (String)this.value;
        }
        throw this.unmatchRequestType(FieldType.FIELD_STRING);
    }

    public byte[] imageValue() {
        if (this.value instanceof byte[]) {
            return (byte[])this.value;
        }
        throw this.unmatchRequestType(FieldType.FIELD_IMAGE);
    }

    public Object getValue() {
        return this.value;
    }

    private RuntimeException unmatchRequestType(FieldType ftype) {
        UnmatchTypeException e = new UnmatchTypeException();
        e.addScene("RealType", this.attr.getType());
        e.addScene("RequestType", ftype);
        return e;
    }

    public void setValue(byte v) {
        if (!FieldType.integerType(this.attr.getType())) {
            throw this.unmatchFieldType(FieldType.FIELD_BYTE);
        }
        this.value = new Byte(v);
    }

    public void setValue(Byte v) {
        if (!FieldType.integerType(this.attr.getType())) {
            throw this.unmatchFieldType(FieldType.FIELD_BYTE);
        }
        this.value = v;
    }

    public void setValue(short v) {
        if (!FieldType.integerType(this.attr.getType())) {
            throw this.unmatchFieldType(FieldType.FIELD_SHORT);
        }
        this.value = new Short(v);
    }

    public void setValue(Short v) {
        if (!FieldType.integerType(this.attr.getType())) {
            throw this.unmatchFieldType(FieldType.FIELD_SHORT);
        }
        this.value = v;
    }

    public void setValue(int v) {
        if (!FieldType.integerType(this.attr.getType())) {
            throw this.unmatchFieldType(FieldType.FIELD_INT);
        }
        this.value = new Integer(v);
    }

    public void setValue(Integer v) {
        if (!FieldType.integerType(this.attr.getType())) {
            throw this.unmatchFieldType(FieldType.FIELD_INT);
        }
        this.value = v;
    }

    public void setValue(long v) {
        if (!FieldType.integerType(this.attr.getType())) {
            throw this.unmatchFieldType(FieldType.FIELD_LONG);
        }
        this.value = new Long(v);
    }

    public void setValue(Long v) {
        if (!FieldType.integerType(this.attr.getType())) {
            throw this.unmatchFieldType(FieldType.FIELD_LONG);
        }
        this.value = v;
    }

    public void setValue(float v) {
        if (!FieldType.decimalType(this.attr.getType())) {
            throw this.unmatchFieldType(FieldType.FIELD_FLOAT);
        }
        this.value = new Float(v);
    }

    public void setValue(Float v) {
        if (!FieldType.decimalType(this.attr.getType())) {
            throw this.unmatchFieldType(FieldType.FIELD_FLOAT);
        }
        this.value = v;
    }

    public void setValue(double v) {
        if (!FieldType.decimalType(this.attr.getType())) {
            throw this.unmatchFieldType(FieldType.FIELD_DOUBLE);
        }
        this.value = new Double(v);
    }

    public void setValue(Double v) {
        if (!FieldType.decimalType(this.attr.getType())) {
            throw this.unmatchFieldType(FieldType.FIELD_DOUBLE);
        }
        this.value = v;
    }

    public void setValue(String v) {
        if (this.attr.getType() == FieldType.FIELD_STRING) {
            this.value = v == null ? "" : v;
        } else {
            throw this.unmatchFieldType(FieldType.FIELD_STRING);
        }
    }

    public void setValue(byte[] v) {
        if (this.attr.getType() != FieldType.FIELD_IMAGE) {
            throw this.unmatchFieldType(FieldType.FIELD_IMAGE);
        }
        this.value = v;
    }

    private RuntimeException unmatchFieldType(FieldType ftype) {
        UnmatchTypeException e = new UnmatchTypeException();
        e.addScene("AttrType", this.attr.getType());
        e.addScene("SetType", ftype);
        return e;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

