/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.data;

import com.dc.eai.data.CompositeData;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CompositeDataSet {
    private Map map = new HashMap();
    private String[] names = new String[10];
    private int size = 0;
    private DataIterator it = new DataIterator();

    public void putData(String name, CompositeData data) {
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("bad-data-name");
        }
        if (this.size >= this.names.length) {
            String[] temp = new String[this.names.length * 2];
            System.arraycopy(this.names, 0, temp, 0, this.names.length);
            this.names = temp;
        }
        this.map.put(name, data);
        this.names[this.size++] = name;
    }

    public CompositeData getData(String name) {
        if (name == null || name.equals("")) {
            return null;
        }
        return (CompositeData)this.map.get(name);
    }

    public CompositeData getDefaultData() {
        if (this.names[0] != null) {
            return this.getData(this.names[0]);
        }
        return null;
    }

    public CompositeData getCurrentData() {
        String dataname;
        if (this.names.length > 0 && (dataname = this.names[this.size - 1]) != null) {
            return this.getData(dataname);
        }
        return null;
    }

    public CompositeData getPreviousData() {
        String dataname;
        if (this.size > 1 && (dataname = this.names[this.size - 2]) != null) {
            return this.getData(dataname);
        }
        return this.getCurrentData();
    }

    public void removeData(String name) {
        this.map.remove(name);
    }

    public Iterator iterator() {
        return this.it;
    }

    public int size() {
        return this.size;
    }

    private class DataIterator
    implements Iterator {
        private int index = 0;

        DataIterator() {
        }

        public boolean hasNext() {
            return this.index < CompositeDataSet.this.size;
        }

        public Object next() {
            return CompositeDataSet.this.names[this.index++];
        }

        public void remove() {
            if (this.index == CompositeDataSet.this.size - 1) {
                return;
            }
            ((CompositeDataSet)CompositeDataSet.this).names[this.index] = null;
            System.arraycopy(CompositeDataSet.this.names, this.index + 1, CompositeDataSet.this.names, this.index, CompositeDataSet.this.size - (this.index + 1));
            CompositeDataSet.this.size--;
        }
    }
}

