/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.data;

import com.dc.eai.data.Array;
import com.dc.eai.data.CompositeData;
import com.dc.eai.data.Field;
import com.dc.eai.data.FieldType;
import com.dc.util.StringUtils;
import com.dc.util.enums.Enum;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class AtomData
implements Serializable {
    public static final AtomDataType FIELD_TYPE = new AtomDataType("FieldType");
    public static final AtomDataType STRUCT_TYPE = new AtomDataType("StructType");
    public static final AtomDataType ARRAY_TYPE = new AtomDataType("ArrayType");
    protected AtomDataType type;
    private Map attributes;

    public AtomDataType getCDType() {
        return this.type;
    }

    public boolean isField() {
        return this.type == FIELD_TYPE;
    }

    public boolean isStruct() {
        return this.type == STRUCT_TYPE;
    }

    public boolean isArray() {
        return this.type == ARRAY_TYPE;
    }

    public void setAttribute(String name, String value) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        if (name != null && !name.equals("")) {
            this.attributes.put(name, value);
        }
    }

    public String getAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        if (name != null && !name.equals("")) {
            return (String)this.attributes.get(name);
        }
        throw new IllegalArgumentException("bad-attribute-name");
    }

    public Iterator attributeIterator() {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.keySet().iterator();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        try {
            this.toString(sb, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }

    public void toString(StringBuffer sb, int tabs) {
        Object fieldValue = "*******";
        String name = null;
        if (this.isField()) {
            Field fld = (Field)this;
            if (fld.getAttr().getType() == FieldType.FIELD_IMAGE) {
                sb.append("Field {  type=" + fld.getFieldType() + "  length=" + fld.getAttr().getLength() + "  scale=" + fld.getAttr().getScale() + "  pin=" + fld.getAttr().getPin() + "  value= {" + StringUtils.bytesToString(fld.imageValue()) + "} }\n");
            } else {
                if (!fld.getAttr().getPin()) {
                    fieldValue = fld.getValue();
                }
                sb.append("Field {  type=" + fld.getFieldType() + "  length=" + fld.getAttr().getLength() + "  scale=" + fld.getAttr().getScale() + "  pin=" + fld.getAttr().getPin() + "  value= {" + fieldValue + "} }\n");
            }
        } else if (this.isArray()) {
            Array array = (Array)this;
            sb.append("Array [" + array.size() + "] {\n");
            int i = 0;
            while (i < array.size()) {
                AtomData data = array.getObject(i);
                sb.append(this.attrsToString(tabs));
                sb.append("    " + i + "\t: ");
                data.toString(sb, tabs + 1);
                ++i;
            }
            sb.append(this.attrsToString(tabs));
            sb.append("}\n");
        } else if (this.isStruct()) {
            CompositeData struct = (CompositeData)this;
            sb.append("CompositeData {\n");
            Iterator it = struct.iterator();
            while (it.hasNext()) {
                name = (String)it.next();
                AtomData data = struct.getObject(name);
                sb.append(this.attrsToString(tabs));
                sb.append("   \"" + name + "\"\t: ");
                data.toString(sb, tabs + 1);
            }
            sb.append(this.attrsToString(tabs));
            sb.append("}\n");
        }
    }

    private String attrsToString(int tabs) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < tabs) {
            sb.append("    ");
            ++i;
        }
        return sb.toString();
    }

    static class AtomDataType
    extends Enum {
        private AtomDataType(String type) {
            super(type);
        }
    }
}

