/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.data;

import com.dc.eai.data.AtomData;
import com.dc.eai.data.CompositeData;
import com.dc.eai.data.Field;
import com.dc.eai.data.FieldType;
import com.dc.eai.data.UnmatchTypeException;
import java.util.ArrayList;
import java.util.List;

public class Array
extends AtomData {
    private List data = new ArrayList();
    private AtomData.AtomDataType itemType = null;
    private FieldType fieldType = null;
    private boolean cascadeCreate = false;
    private List base = new ArrayList();

    public Array() {
        this(false);
    }

    public Array(boolean createFlag) {
        this.cascadeCreate = createFlag;
        this.type = ARRAY_TYPE;
    }

    public void addBase(Array ba) {
        if (ba != null && ba != this) {
            this.base.add(ba);
        }
    }

    public int size() {
        return this.data.size();
    }

    public void addField(Field field) {
        this.addField(this.data.size(), field);
    }

    public void addField(int index, Field field) {
        if (this.itemType == null) {
            this.itemType = FIELD_TYPE;
        } else {
            if (this.itemType != FIELD_TYPE) {
                throw new UnmatchTypeException();
            }
            if (this.fieldType == null) {
                this.fieldType = field.getAttr().getType();
            } else if (this.fieldType != field.getAttr().getType()) {
                throw new UnmatchTypeException();
            }
        }
        if (index < this.data.size()) {
            this.data.set(index, field);
        } else {
            this.data.add(index, field);
        }
    }

    public void addStruct(CompositeData struct) {
        this.addStruct(this.data.size(), struct);
    }

    public void addStruct(int index, CompositeData struct) {
        if (this.itemType == null) {
            this.itemType = STRUCT_TYPE;
        } else if (this.itemType != STRUCT_TYPE) {
            throw new UnmatchTypeException();
        }
        if (index < this.data.size()) {
            this.data.set(index, struct);
        } else {
            this.data.add(index, struct);
        }
    }

    public void addArray(Array array) {
        this.addArray(this.data.size(), array);
    }

    public void addArray(int index, Array array) {
        if (this.itemType == null) {
            this.itemType = ARRAY_TYPE;
        } else if (this.itemType != ARRAY_TYPE) {
            throw new UnmatchTypeException();
        }
        if (index < this.data.size()) {
            this.data.set(index, array);
        } else {
            this.data.add(index, array);
        }
    }

    public AtomData getObject(int index) {
        AtomData atom = this.getObjectFromLocal(index);
        if (atom != null && atom.isArray()) {
            AtomData baseAtom = this.getObjectFromBase(index);
            if (baseAtom != null && baseAtom.isArray()) {
                ((Array)atom).addBase((Array)baseAtom);
            }
            if (baseAtom != null && baseAtom.isStruct()) {
                ((CompositeData)atom).addBase((CompositeData)baseAtom);
            }
        }
        if (atom == null) {
            atom = this.getObjectFromBase(index);
        }
        return atom;
    }

    private AtomData getObjectFromLocal(int index) {
        if (index >= this.size()) {
            return null;
        }
        return (AtomData)this.data.get(index);
    }

    private AtomData getObjectFromBase(int index) {
        int size = this.base.size();
        for (int i = 0; i < this.base.size(); ++i) {
            Array array = (Array)this.base.get(i);
            AtomData atom = array.getObject(index);
            if (atom == null) continue;
            return atom;
        }
        return null;
    }

    public CompositeData getStruct(int index) {
        AtomData obj = this.getObject(index);
        if (obj == null) {
            return null;
        }
        if (obj.isStruct()) {
            return (CompositeData)obj;
        }
        throw new UnmatchTypeException();
    }

    public Field getField(int index) {
        AtomData obj = this.getObject(index);
        if (obj == null) {
            return null;
        }
        if (obj.isField()) {
            return (Field)obj;
        }
        throw new UnmatchTypeException();
    }

    public Array getArray(int index) {
        AtomData obj = this.getObject(index);
        if (obj == null) {
            return null;
        }
        if (obj.isArray()) {
            return (Array)obj;
        }
        throw new UnmatchTypeException();
    }

    public boolean isCascadeCreate() {
        return this.cascadeCreate;
    }

    public void setCascadeCreate(boolean b) {
        this.cascadeCreate = b;
    }
}

