/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.conv.packconv;

import com.dc.eai.config.IOConfig;
import com.dc.eai.conv.InputPacket;
import com.dc.eai.conv.OutputPacket;
import com.dc.eai.conv.PackageConverter;
import com.dc.eai.data.Array;
import com.dc.eai.data.AtomData;
import com.dc.eai.data.CompositeData;
import com.dc.eai.data.Field;
import com.dc.eai.data.FieldAttr;
import com.dc.eai.data.FieldType;
import com.dc.util.NumberUtils;
import com.dc.util.xml.CommonData;
import com.dc.util.xml.XMLCommonData;
import com.dc.util.xml.store.XMLConverter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public final class StandardPackageConverter
implements PackageConverter {
    private static final Log log = LogFactory.getLog((Class)StandardPackageConverter.class);
    private static final String ROOT_TAG = "service";
    private static final String SYS_HEADER_TAG = "sys-header";
    private static final String APP_HEADER_TAG = "app-header";
    private static final String BODY_TAG = "body";
    private static final String DATA_TAG = "data";
    private static final String FIELD_TAG = "field";
    private static final String ARRAY_TAG = "array";
    private static final String STRUCT_TAG = "struct";
    private static final String STATUS = "status";
    private static final String ERROR_CODE = "error-code";
    private static final String ERROR_MSG = "error-msg";
    private static final BASE64Encoder encoder = new BASE64Encoder();
    private static final BASE64Decoder decoder = new BASE64Decoder();

    public void unpack(InputPacket packet, CompositeData data, IOConfig config) {
        if (log.isInfoEnabled()) {
            log.info((Object)"\u4f7f\u7528\u6807\u51c6\u65b9\u5f0f\u8fdb\u884c\u62c6\u5305");
        }
        XMLCommonData commonData = new XMLCommonData();
        byte[] xmlData = packet.getBuff();
        packet.advance(packet.getLength());
        if (log.isInfoEnabled()) {
            log.info((Object)"\u5c06\u8f93\u5165\u62a5\u6587\u4e2d\u7684\u5b57\u8282\u6570\u7ec4\u8f6c\u6362\u4e3aCommonData!");
        }
        XMLConverter xmlconv = new XMLConverter();
        xmlconv.load((CommonData)commonData, xmlData);
        if (log.isInfoEnabled()) {
            log.info((Object)"\u5c06\u8f93\u5165\u62a5\u6587\u4e2d\u7684CommonData\u8f6c\u6362\u4e3aCompositeData!");
        }
        StandardPackageConverter.CommonDatatoCompositeData(commonData, data);
        if (log.isInfoEnabled()) {
            log.info((Object)("\u4f7f\u7528\u6807\u51c6\u65b9\u5f0f\u8fdb\u884c\u62c6\u5305\u6210\u529f\uff0c\u5f97\u5230\u7684\u6570\u636e\u4e3a:\n" + data));
        }
    }

    public void pack(OutputPacket packet, CompositeData data, IOConfig config) {
        if (log.isInfoEnabled()) {
            log.info((Object)"\u4f7f\u7528\u6807\u51c6\u65b9\u5f0f\u8fdb\u884c\u7ec4\u5305");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"\u5c06CompositeData\u8f6c\u6362\u4e3aCommonData");
        }
        CommonData commonData = StandardPackageConverter.toCommonData(data);
        if (log.isInfoEnabled()) {
            log.info((Object)"\u5c06CommonData\u8f6c\u6362\u4e3a\u6807\u51c6XML\u5b57\u8282\u6d41\uff0c\u7f6e\u5165OutputPacket");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XMLConverter xmlconv = new XMLConverter();
        xmlconv.store(commonData, out);
        byte[] xmlData = out.toByteArray();
        int length = xmlData.length;
        packet.ensure(length);
        System.arraycopy(xmlData, 0, packet.getBuff(), packet.getOffset(), length);
        packet.advance(length);
        if (log.isInfoEnabled()) {
            log.info((Object)"\u4f7f\u7528\u6807\u51c6\u65b9\u5f0f\u8fdb\u884c\u7ec4\u5305\u6210\u529f");
        }
    }

    private static void CommonDatatoCompositeData(CommonData root, CompositeData data) {
        if (root.childCount() == 1) {
            int i;
            int count;
            CommonData commonData;
            CommonData realroot = root.getChild(0);
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u5f00\u59cb\u62c6\u89e3\u7cfb\u7edf\u5934!");
            }
            if ((commonData = realroot.getChild(SYS_HEADER_TAG)) != null) {
                count = commonData.childCount();
                for (i = 0; i < count; ++i) {
                    CommonData sys_header = commonData.getChild(i);
                    if (sys_header == null) continue;
                    StandardPackageConverter.toCompositeData(sys_header, data);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u62c6\u89e3\u7cfb\u7edf\u5934\u540e\u5f97\u5230\u7684CompositeData\u4e3a:\n" + data));
                log.debug((Object)"\u5f00\u59cb\u62c6\u89e3\u5e94\u7528\u5934!");
            }
            if ((commonData = realroot.getChild(APP_HEADER_TAG)) != null) {
                count = commonData.childCount();
                for (i = 0; i < count; ++i) {
                    CommonData app_header = commonData.getChild(i);
                    if (app_header == null) continue;
                    StandardPackageConverter.toCompositeData(app_header, data);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u62c6\u89e3\u5e94\u7528\u5934\u540e\u5f97\u5230\u7684CompositeData\u4e3a:\n" + data));
                log.debug((Object)"\u5f00\u59cb\u62c6\u89e3\u62a5\u6587\u4f53!");
            }
            if ((commonData = realroot.getChild(BODY_TAG)) != null) {
                count = commonData.childCount();
                for (i = 0; i < count; ++i) {
                    CommonData body = commonData.getChild(i);
                    if (body == null) continue;
                    StandardPackageConverter.toCompositeData(body, data);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u62c6\u89e3\u62a5\u6587\u4f53\u540e\u5f97\u5230\u7684CompositeData\u4e3a:\n" + data));
            }
        }
    }

    private static CompositeData toCompositeData(CommonData commonData, CompositeData data) {
        String tagname;
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u6839\u636eCommonData\u5bf9\u8c61\u6784\u9020CompositeData\u5bf9\u8c61.");
        }
        if ((tagname = commonData.getName()).equals(STATUS)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u5904\u7406\u6570\u636e:status");
            }
            FieldAttr fieldttr = new FieldAttr(FieldType.FIELD_STRING, 1);
            Field field = new Field(fieldttr);
            field.setValue((String)commonData.getValue());
            data.addField(STATUS, field);
        } else if (tagname.equals(ERROR_CODE)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u5904\u7406\u6570\u636e:error_code");
            }
            FieldAttr fieldttr = new FieldAttr(FieldType.FIELD_STRING, 20);
            Field field = new Field(fieldttr);
            field.setValue((String)commonData.getValue());
            data.addField("errCode", field);
        } else if (tagname.equals(ERROR_MSG)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u5904\u7406\u6570\u636e:error_msg");
            }
            FieldAttr fieldttr = new FieldAttr(FieldType.FIELD_STRING, 10000);
            Field field = new Field(fieldttr);
            field.setValue((String)commonData.getValue());
            data.addField("errMsg", field);
        } else if (tagname.equals(DATA_TAG)) {
            String dataName = (String)commonData.getAttribute("name");
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u5904\u7406\u6570\u636e" + dataName));
            }
            int count = commonData.childCount();
            for (int i = 0; i < count; ++i) {
                CommonData child = commonData.getChild(i);
                if (!child.getName().equals("attribute-list")) {
                    data.addObject(dataName, StandardPackageConverter.populateData(child));
                    continue;
                }
                int attr_count = child.childCount();
                for (int j = 0; j < attr_count; ++j) {
                    CommonData attr = child.getChild(j);
                    data.getObject(dataName).setAttribute((String)attr.getAttribute("name"), (String)attr.getValue());
                }
            }
        }
        return data;
    }

    private static AtomData populateData(CommonData commonData) {
        String name = commonData.getName();
        if (name.equals(FIELD_TAG)) {
            String type = (String)commonData.getAttribute("type");
            FieldType fieldType = FieldType.getEnum(type);
            int length = StandardPackageConverter.getLength(commonData);
            int scale = StandardPackageConverter.getScale(commonData);
            FieldAttr fieldAttr = new FieldAttr(fieldType, length, scale);
            Field field = new Field(fieldAttr);
            String strValue = (String)commonData.getValue();
            if (fieldType == FieldType.FIELD_BYTE) {
                byte value = (byte)NumberUtils.intValue(strValue);
                field.setValue(value);
            } else if (fieldType == FieldType.FIELD_DOUBLE) {
                double value = NumberUtils.doubleValue(strValue);
                field.setValue(value);
            } else if (fieldType == FieldType.FIELD_FLOAT) {
                float value = (float)NumberUtils.doubleValue(strValue);
                field.setValue(value);
            } else if (fieldType == FieldType.FIELD_INT) {
                int value = NumberUtils.intValue(strValue);
                field.setValue(value);
            } else if (fieldType == FieldType.FIELD_INT24 || fieldType == FieldType.FIELD_LONG) {
                long value = NumberUtils.longValue(strValue);
                field.setValue(value);
            } else if (fieldType == FieldType.FIELD_SHORT) {
                short value = (short)NumberUtils.intValue(strValue);
                field.setValue(value);
            } else if (fieldType == FieldType.FIELD_IMAGE) {
                try {
                    byte[] value = decoder.decodeBuffer(strValue);
                    field.setValue(value);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                field.setValue(strValue);
            }
            return field;
        }
        if (name.equals(ARRAY_TAG)) {
            Array array = new Array();
            int count = commonData.childCount();
            if (count > 0) {
                for (int i = 0; i < count; ++i) {
                    CommonData childCommonData = commonData.getChild(i);
                    String childName = childCommonData.getName();
                    if (childName.equals(STRUCT_TAG)) {
                        array.addStruct((CompositeData)StandardPackageConverter.populateData(childCommonData));
                        continue;
                    }
                    if (childName.equals(ARRAY_TAG)) {
                        array.addArray((Array)StandardPackageConverter.populateData(childCommonData));
                        continue;
                    }
                    if (!childName.equals(FIELD_TAG)) continue;
                    array.addField((Field)StandardPackageConverter.populateData(childCommonData));
                }
            }
            return array;
        }
        CompositeData struct = new CompositeData();
        int count = commonData.childCount();
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                CommonData childCommonData = commonData.getChild(i);
                struct = StandardPackageConverter.toCompositeData(childCommonData, struct);
            }
        }
        return struct;
    }

    private static int getLength(CommonData commonData) {
        int length;
        if (commonData.getAttribute("length") == null) {
            length = 0;
        } else {
            try {
                length = Integer.parseInt((String)commonData.getAttribute("length"));
            }
            catch (NumberFormatException e) {
                length = 0;
            }
        }
        return length;
    }

    private static int getScale(CommonData commonData) {
        int scale;
        if (commonData.getAttribute("scale") == null) {
            scale = 0;
        } else {
            try {
                scale = Integer.parseInt((String)commonData.getAttribute("scale"));
            }
            catch (NumberFormatException e) {
                scale = 0;
            }
        }
        return scale;
    }

    private static CommonData toCommonData(CompositeData data) {
        XMLCommonData commonData = new XMLCommonData();
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u5411CommonData\u4e2d\u52a0\u5165\u6839\u6807\u7b7e[service]");
        }
        CommonData root = commonData.addChild(ROOT_TAG);
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u5411CommonData\u4e2d\u52a0\u5165\u4f53\u6807\u7b7e[body]");
        }
        CommonData body = root.addChild(BODY_TAG);
        if (data != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u5c06CompositeData\u4f5c\u4e3a[body]\u5b50\u8282\u70b9\uff0c\u52a0\u5165\u5230CommonData");
            }
            StandardPackageConverter.toCommonData(body, data);
        }
        return commonData;
    }

    private static CommonData toCommonData(CommonData commonData, CompositeData data) {
        Iterator iter = data.iterator();
        while (iter.hasNext()) {
            Iterator attrIter;
            String name = (String)iter.next();
            AtomData atomData = data.getObject(name);
            if (atomData == null) continue;
            CommonData dataElement = commonData.addChild(DATA_TAG);
            if (atomData.isField()) {
                StandardPackageConverter.toCommonData(dataElement, (Field)atomData, name);
            } else if (atomData.isArray()) {
                dataElement.setAttribute("name", name);
                Array array = (Array)atomData;
                StandardPackageConverter.toCommonData(dataElement, array);
            } else {
                CompositeData struct = (CompositeData)atomData;
                dataElement.setAttribute("name", name);
                CommonData structElement = dataElement.addChild(STRUCT_TAG);
                StandardPackageConverter.toCommonData(structElement, struct);
            }
            if ((attrIter = atomData.attributeIterator()) == null || !attrIter.hasNext()) continue;
            CommonData attrList = dataElement.addChild("attribute-list");
            while (attrIter.hasNext()) {
                String attrName = (String)attrIter.next();
                CommonData attrData = attrList.addChild("attribute");
                attrData.setAttribute("name", attrName);
                attrData.setValue(atomData.getAttribute(attrName));
            }
        }
        return commonData;
    }

    private static void toCommonData(CommonData commonData, Array array) {
        CommonData arrayElement = commonData.addChild(ARRAY_TAG);
        for (int i = 0; i < array.size(); ++i) {
            AtomData arrayItem = array.getObject(i);
            if (arrayItem.isField()) {
                StandardPackageConverter.toCommonData(arrayElement, (Field)arrayItem, "");
                continue;
            }
            if (arrayItem.isArray()) {
                StandardPackageConverter.toCommonData(arrayElement, (Array)arrayItem);
                continue;
            }
            CommonData struct = arrayElement.addChild(STRUCT_TAG);
            StandardPackageConverter.toCommonData(struct, (CompositeData)arrayItem);
        }
    }

    private static void toCommonData(CommonData commonData, Field field, String name) {
        CommonData dataElement = name.equals("") ? commonData.addChild(DATA_TAG) : commonData;
        FieldAttr fieldAttr = field.getAttr();
        FieldType fieldType = fieldAttr.getType();
        int length = fieldAttr.getLength();
        int scale = fieldAttr.getScale();
        dataElement.setAttribute("name", name);
        CommonData fieldElement = dataElement.addChild(FIELD_TAG);
        fieldElement.setAttribute("type", fieldType.getName());
        fieldElement.setAttribute("length", "" + length);
        fieldElement.setAttribute("scale", "" + scale);
        if (fieldType == FieldType.FIELD_IMAGE) {
            String value = encoder.encode((byte[])field.getValue());
            fieldElement.setValue(value);
        } else {
            fieldElement.setValue("" + field.getValue());
        }
    }
}

