/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.conv.packconv;

import com.dc.eai.config.ArrayIOConfig;
import com.dc.eai.config.AtomDataIOConfig;
import com.dc.eai.config.FieldIOConfig;
import com.dc.eai.config.IOConfig;
import com.dc.eai.config.StructIOConfig;
import com.dc.eai.conv.ConfigException;
import com.dc.eai.conv.FieldConverter;
import com.dc.eai.conv.FieldConverterFactory;
import com.dc.eai.conv.InputPacket;
import com.dc.eai.conv.OutputPacket;
import com.dc.eai.conv.PackageConverter;
import com.dc.eai.conv.Packet;
import com.dc.eai.conv.PacketException;
import com.dc.eai.data.Array;
import com.dc.eai.data.CompositeData;
import com.dc.eai.data.Field;
import com.dc.eai.data.FieldAttr;
import com.dc.expr.CompositeDataExprData;
import com.dc.expr.Exp;
import com.dc.expr.ExpType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SequencePackageConverter
implements PackageConverter {
    private static final Log log = LogFactory.getLog((Class)SequencePackageConverter.class);

    public void unpack(InputPacket packet, CompositeData data, IOConfig config) {
        this.packOrUnpack(packet, data, config, false);
    }

    public void pack(OutputPacket packet, CompositeData data, IOConfig config) {
        this.packOrUnpack(packet, data, config, true);
    }

    private void packOrUnpack(Packet packet, CompositeData data, IOConfig config, boolean isPack) throws PacketException, ConfigException {
        if (null == packet || null == data) {
            PacketException pe = new PacketException("\u65e0\u6548\u8f93\u5165\u53c2\u6570\uff01\uff01");
            pe.addScene("\u9519\u8bef\u63d0\u793a\uff1a", "\u8f93\u5165\u6216\u8f93\u51fa\u62a5\u6587\u53c2\u6570Packet\u4e0e\u7edf\u4e00\u6570\u636e\u683c\u5f0fCompsiteData\u53c2\u6570\u4e3anull!");
            throw pe;
        }
        int count = config.size();
        for (int i = 0; i < count; ++i) {
            Object item = config.getObject(i);
            this.elementDispatch(packet, data, item, isPack);
        }
    }

    protected void elementDispatch(Packet packet, CompositeData data, Object item, boolean isPack) throws ConfigException {
        if (item instanceof FieldIOConfig) {
            FieldIOConfig fieldConfig = (FieldIOConfig)item;
            this.packOrUpackField(packet, data, fieldConfig, isPack);
        } else if (item instanceof StructIOConfig) {
            StructIOConfig structConfig = (StructIOConfig)item;
            this.packOrUnpackStruct(packet, data.getStruct(structConfig.getName()), structConfig, isPack);
        } else if (item instanceof ArrayIOConfig) {
            ArrayIOConfig arrayConfig = (ArrayIOConfig)item;
            this.packOrUnpackArray(packet, data, arrayConfig, isPack);
        } else if (log.isErrorEnabled()) {
            log.error((Object)"\u5f53\u524d\u5904\u7406\u8282\u70b9\u4e0d\u662f\u62c6\u7ec4\u5305\u914d\u7f6e\u89c4\u5219\u6587\u4ef6\u4e2d\u5141\u8bb8\u7684\u4efb\u4f55\u4e00\u79cd\uff0c\u8bf7\u68c0\u67e5\u76f8\u5173\u914d\u7f6e\u6587\u4ef6\uff01\uff01");
        }
    }

    protected void packOrUpackField(Packet packet, CompositeData data, FieldIOConfig config, boolean isPack) throws ConfigException {
        if (!this.isOption(data, config.getOption())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(config.getName() + "\u8282\u70b9\u6839\u636eoption\u5c5e\u6027\u914d\u7f6e\u7ed3\u679c\u4e0d\u4f5c\u5904\u7406\uff01\uff01"));
            }
            return;
        }
        String mode = config.getStoreMode();
        FieldConverter fc = FieldConverterFactory.getInstance().getFieldConverter(mode);
        if (isPack) {
            Field value = data.getField(config.getName());
            if (null == value) {
                if (config.isRequired()) {
                    PacketException pe = new PacketException("\u57fa\u672c\u57df\u6570\u503c\u4e0d\u5b58\u5728\u4e14\u8be5\u57df\u8bbe\u7f6e\u4e3a\u5fc5\u987b\u6709\u503c\uff0c\u7ec4\u5305\u65f6\u51fa\u73b0\u9519\u8bef\uff01\uff01");
                    pe.addScene("\u7ec4\u5305\u51fa\u73b0\u9519\u8bef\u7684\u57fa\u672c\u57df\u540d\u79f0\u4e3a\uff1a", config.getName());
                    throw pe;
                }
                value = new Field(new FieldAttr(config.getType(), config.getLength(), config.getScale()));
                data.addField(config.getName(), value);
            }
            fc.pack((OutputPacket)packet, data, config);
        } else {
            fc.unpack((InputPacket)packet, data, config);
        }
    }

    protected void packOrUnpackStruct(Packet packet, CompositeData data, StructIOConfig config, boolean isPack) throws ConfigException {
        int count = config.getSize();
        if (0 == count && log.isErrorEnabled()) {
            log.error((Object)("\u5f53\u524d\u5904\u7406\u7684stuct\u8282\u70b9" + config.getName() + "\u672a\u5b9a\u4e49\u4efb\u4f55\u4e0b\u7ea7\u8282\u70b9\uff0c\u8bf7\u68c0\u67e5\uff01\uff01"));
        }
        for (int i = 0; i < count; ++i) {
            AtomDataIOConfig item = config.getItem(i);
            this.elementDispatch(packet, data, item, isPack);
        }
    }

    protected void packOrUnpackArray(Packet packet, CompositeData data, ArrayIOConfig config, boolean isPack) throws ConfigException {
        Array array;
        int recycle = 0;
        CompositeDataExprData exprData = new CompositeDataExprData(data);
        Exp sizeExp = config.size();
        if (null != sizeExp) {
            Exp option = sizeExp.eval(exprData);
            if (option.getType().equals(ExpType.INT_TYPE)) {
                recycle = option.intValue();
            } else {
                ConfigException ce = new ConfigException("\u5f53\u524d\u5904\u7406\u7684\u6570\u7ec4\u6240\u5b9a\u4e49\u7684\u5faa\u73af\u6b21\u6570\u65e0\u6cd5\u89e3\u6790\u4e3a\u4e00\u4e2a\u6574\u6570\uff01\uff01");
                ce.addScene("\u6570\u7ec4\u540d\u79f0\u4e3a\uff1a", config.getName());
                throw ce;
            }
        }
        if (isPack) {
            array = data.getArray(config.getName());
        } else {
            array = new Array();
            data.addArray(config.getName(), array);
        }
        AtomDataIOConfig item = config.getConfig();
        if (item instanceof FieldIOConfig) {
            FieldIOConfig fieldConfig = (FieldIOConfig)item;
            for (int i = 0; i < recycle; ++i) {
                CompositeData tempData = new CompositeData();
                if (isPack) {
                    tempData.addField(fieldConfig.getName(), array.getField(i));
                }
                this.packOrUpackField(packet, tempData, fieldConfig, isPack);
                if (!isPack) {
                    array.addField(tempData.getField(fieldConfig.getName()));
                    tempData.removeObject(fieldConfig.getName());
                }
                tempData = null;
                if (this.isOption(data, config.getCondition())) {
                    continue;
                }
                break;
            }
        } else if (item instanceof StructIOConfig) {
            StructIOConfig structConfig = (StructIOConfig)item;
            if (config.isVertical()) {
                int count = structConfig.getSize();
                block1: for (int i = 0; i < count; ++i) {
                    for (int j = 0; j < recycle; ++j) {
                        CompositeData inArrayStruct = array.getStruct(j);
                        if (inArrayStruct == null) {
                            inArrayStruct = new CompositeData();
                            array.addStruct(inArrayStruct);
                        }
                        this.elementDispatch(packet, inArrayStruct, structConfig.getItem(i), isPack);
                        if (!this.isOption(data, config.getCondition())) continue block1;
                    }
                }
            } else {
                for (int i = 0; i < recycle; ++i) {
                    CompositeData inArrayStruct = array.getStruct(i);
                    if (inArrayStruct == null) {
                        inArrayStruct = new CompositeData();
                        array.addStruct(inArrayStruct);
                    }
                    this.packOrUnpackStruct(packet, inArrayStruct, structConfig, isPack);
                    if (this.isOption(data, config.getCondition())) {
                        continue;
                    }
                    break;
                }
            }
        } else if (item instanceof ArrayIOConfig) {
            ArrayIOConfig arrayConfig = (ArrayIOConfig)item;
            for (int i = 0; i < recycle; ++i) {
                CompositeData tempData = new CompositeData();
                if (isPack) {
                    tempData.addArray(arrayConfig.getName(), array.getArray(i));
                }
                this.packOrUnpackArray(packet, tempData, arrayConfig, isPack);
                if (!isPack) {
                    array.addArray(tempData.getArray(arrayConfig.getName()));
                    tempData.removeObject(arrayConfig.getName());
                }
                tempData = null;
                if (this.isOption(data, config.getCondition())) {
                    continue;
                }
                break;
            }
        } else if (log.isErrorEnabled()) {
            log.error((Object)"\u5f53\u524d\u5904\u7406\u8282\u70b9\u4e0d\u662f\u62c6\u7ec4\u5305\u914d\u7f6e\u89c4\u5219\u6587\u4ef6\u4e2d\u5141\u8bb8\u7684\u4efb\u4f55\u4e00\u79cd\u6216\u672a\u505a\u4efb\u4f55\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5\u76f8\u5173\u914d\u7f6e\u6587\u4ef6\uff01\uff01");
        }
    }

    protected boolean isOption(CompositeData data, Exp optionExp) {
        boolean result = false;
        if (null == optionExp) {
            return result;
        }
        CompositeDataExprData exprData = new CompositeDataExprData(data);
        if (null != optionExp) {
            Exp option = optionExp.eval(exprData);
            result = option.boolValue();
        }
        return result;
    }
}

