/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.conv.fieldconv;

import com.dc.eai.config.FieldIOConfig;
import com.dc.eai.conv.InputPacket;
import com.dc.eai.conv.OutputPacket;
import com.dc.eai.conv.fieldconv.DefaultFieldConverter;
import com.dc.eai.data.CompositeData;
import com.dc.eai.data.Field;
import com.dc.eai.data.FieldAttr;
import com.dc.eai.data.FieldType;
import com.dc.util.pack.PackUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ZoneDecimalFieldConverter
extends DefaultFieldConverter {
    private static Log log = LogFactory.getLog((Class)ZoneDecimalFieldConverter.class);

    public ZoneDecimalFieldConverter() {
        super("ZoneDecimal");
    }

    public void unpack(InputPacket packet, CompositeData data, FieldIOConfig config) {
        FieldType ftype = config.getType();
        int length = config.getLength();
        int scale = config.getScale();
        if (log.isDebugEnabled()) {
            log.debug((Object)("******** \u914d\u7f6e\u4e2d\u7684\u5143\u6570\u636e,ftype = " + ftype + ",length = " + length + ",scale = " + scale));
        }
        FieldAttr fattr = new FieldAttr(ftype, length, scale);
        if (log.isDebugEnabled()) {
            log.debug((Object)("******** \u57df\u62c6\u5305(ZoneDecimal\u65b9\u5f0f)\u5f00\u59cb,offset = " + packet.getOffset()));
        }
        if (FieldType.numberType(ftype)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("******** Buff = " + packet.getBuff() + ", Offset = " + packet.getOffset() + ", Length = " + length + ", Scale = " + scale));
            }
            if (packet.exceed(length)) {
                throw this.PacketLenOverflowException(packet, length);
            }
            double val = PackUtils.get_zone_decimal(packet.getBuff(), packet.getOffset(), length, scale);
            if (log.isDebugEnabled()) {
                log.debug((Object)("******** \u8c03\u7528PackUtils.get_zone_decimal()\u5f97\u5230" + val));
            }
            Field value = new Field(fattr);
            if (FieldType.decimalType(ftype)) {
                value.setValue(new Double(val));
            } else {
                value.setValue(new Long((long)val));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("******** Value = " + value.doubleValue()));
            }
            data.addField(config.getName(), value);
            packet.advance(length);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"******** \u975e\u6570\u503c\u7c7b\u578b\uff0c\u8c03\u7528Default\u65b9\u5f0f\u8fdb\u884c\u62c6\u5305");
            }
            super.unpack(packet, data, config);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"******** \u57df\u62c6\u5305(ZoneDecimal\u65b9\u5f0f)\u7ed3\u675f");
        }
    }

    public void pack(OutputPacket packet, CompositeData data, FieldIOConfig config) {
        Field value;
        if (log.isDebugEnabled()) {
            log.debug((Object)"******** \u57df\u6253\u5305(ZoneDecimal\u65b9\u5f0f)\u5f00\u59cb");
        }
        if ((value = data.getField(config.getName())).getValue() == null) {
            return;
        }
        FieldType ftype = config.getType();
        if (FieldType.numberType(ftype)) {
            int length = config.getLength();
            int scale = config.getScale();
            packet.ensure(length);
            PackUtils.put_zone_decimal(packet.getBuff(), packet.getOffset(), value.doubleValue(), length, scale);
            packet.advance(length);
            if (log.isDebugEnabled()) {
                log.debug((Object)("******** Buff = " + packet.getBuff() + ", Offset = " + (packet.getOffset() - length) + ", Length = " + length + ", Scale = " + scale));
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"******** \u975e\u6570\u503c\u7c7b\u578b\uff0c\u8c03\u7528Default\u65b9\u5f0f\u8fdb\u884c\u6253\u5305");
            }
            super.pack(packet, data, config);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"******** \u57df\u6253\u5305(ZoneDecimal\u65b9\u5f0f)\u7ed3\u675f");
        }
    }
}

