/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.conv.fieldconv;

import com.dc.eai.config.FieldIOConfig;
import com.dc.eai.conv.FieldConverter;
import com.dc.eai.conv.FieldConverterFactory;
import com.dc.eai.conv.InputPacket;
import com.dc.eai.conv.OutputPacket;
import com.dc.eai.conv.PacketException;
import com.dc.eai.conv.fieldconv.DefaultFieldConverter;
import com.dc.eai.conv.fieldconv.PackDecimalFieldConverter;
import com.dc.eai.data.CompositeData;
import com.dc.eai.data.Field;
import com.dc.eai.data.FieldAttr;
import com.dc.eai.data.FieldType;
import com.dc.util.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WithLengthFieldConverter
extends DefaultFieldConverter {
    private static final Log log = LogFactory.getLog((Class)WithLengthFieldConverter.class);
    private String name;
    private FieldType type;
    private int length;
    private int scale;
    private String storeMode;
    private String fieldmode;
    private FieldIOConfig lengthconfig;

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = FieldType.getFieldType(type);
    }

    public void setLength(String length) {
        this.length = Integer.parseInt(length);
    }

    public void setScale(String scale) {
        this.scale = Integer.parseInt(scale);
    }

    public void setStoreMode(String storeMode) {
        this.storeMode = storeMode;
    }

    public FieldIOConfig getLengthConfig() {
        return this.lengthconfig;
    }

    public WithLengthFieldConverter() {
        super("WithLength");
    }

    public void unpack(InputPacket packet, CompositeData data, FieldIOConfig config) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"******** \u57df\u62c6\u5305(WithLength\u65b9\u5f0f)\u5f00\u59cb");
        }
        if (this.lengthconfig == null) {
            this.lengthconfig = new FieldIOConfig();
            this.lengthconfig.setName(this.name);
            this.lengthconfig.setType(this.type);
            this.lengthconfig.setLength(this.length);
            this.lengthconfig.setScale(this.scale);
            this.lengthconfig.setStoreMode(this.storeMode);
        }
        String mode = this.lengthconfig.getStoreMode();
        FieldConverter lengthconverter = FieldConverterFactory.getInstance().getFieldConverter(mode);
        FieldConverter fieldconverter = FieldConverterFactory.getInstance().getFieldConverter(this.fieldmode);
        if (log.isDebugEnabled()) {
            log.debug((Object)"******** \u57df\u62c6\u5305(WithLength\u65b9\u5f0f)\u5f00\u59cb");
        }
        CompositeData tempData = new CompositeData();
        lengthconverter.unpack(packet, tempData, this.lengthconfig);
        Field lengthfield = tempData.getField(this.lengthconfig.getName());
        int definedLength = 0;
        if (this.lengthconfig.getType() == FieldType.FIELD_STRING) {
            definedLength = NumberUtils.intValue(lengthfield.strValue());
        } else if (this.lengthconfig.getType() == FieldType.FIELD_INT) {
            definedLength = lengthfield.intValue();
        } else if (this.lengthconfig.getType() == FieldType.FIELD_SHORT) {
            definedLength = lengthfield.shortValue();
        } else {
            throw new PacketException("FieldTypeErr");
        }
        if (!(fieldconverter instanceof PackDecimalFieldConverter)) {
            config.setLength(definedLength);
            if (log.isDebugEnabled()) {
                log.debug((Object)("******** DefinedLength = " + definedLength));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("******** \u57df\u91c7\u7528PackDecimal\u65b9\u5f0f\u8fdb\u884c\u62c6\u5305\uff0c\u957f\u5ea6\u4e3a" + config.getLength()));
        }
        fieldconverter.unpack(packet, data, config);
        if (log.isDebugEnabled()) {
            log.debug((Object)("******** Value = " + data.getField(config.getName()).getValue()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"******** \u57df\u62c6\u5305(WithLength\u65b9\u5f0f)\u7ed3\u675f");
        }
    }

    public void pack(OutputPacket packet, CompositeData data, FieldIOConfig config) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"******** \u57df\u6253\u5305(WithLength\u65b9\u5f0f)\u5f00\u59cb");
        }
        if (this.lengthconfig == null) {
            this.lengthconfig = new FieldIOConfig();
            this.lengthconfig.setName(this.name);
            this.lengthconfig.setType(this.type);
            this.lengthconfig.setLength(this.length);
            this.lengthconfig.setScale(this.scale);
            this.lengthconfig.setStoreMode(this.storeMode);
        }
        String mode = this.lengthconfig.getStoreMode();
        FieldConverter lengthconverter = FieldConverterFactory.getInstance().getFieldConverter(mode);
        FieldConverter fieldconverter = FieldConverterFactory.getInstance().getFieldConverter(this.fieldmode);
        OutputPacket tempPacket = new OutputPacket();
        Field field = data.getField(config.getName());
        config.setLength(field.getAttr().getLength());
        fieldconverter.pack(tempPacket, data, config);
        int valueLength = tempPacket.getOffset();
        FieldType ftype = this.lengthconfig.getType();
        int lengthLength = this.lengthconfig.getLength();
        Field lengthField = new Field(new FieldAttr(ftype, lengthLength));
        if (ftype == FieldType.FIELD_STRING) {
            lengthField.setValue(Integer.toString(valueLength));
        } else if (ftype == FieldType.FIELD_SHORT || ftype == FieldType.FIELD_INT) {
            lengthField.setValue(valueLength);
        } else {
            throw new PacketException("FieldTypeErr");
        }
        CompositeData tempData = new CompositeData();
        tempData.addField(this.lengthconfig.getName(), lengthField);
        lengthconverter.pack(packet, tempData, this.lengthconfig);
        packet.ensure(valueLength);
        System.arraycopy(tempPacket.getBuff(), 0, packet.getBuff(), packet.getOffset(), valueLength);
        packet.advance(valueLength);
        if (log.isDebugEnabled()) {
            log.debug((Object)"******** \u57df\u6253\u5305(WithLength\u65b9\u5f0f)\u7ed3\u675f");
        }
    }

    public void setFieldmode(String fieldmode) {
        this.fieldmode = fieldmode;
    }
}

