/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.conv.fieldconv;

import com.dc.eai.config.FieldIOConfig;
import com.dc.eai.conv.InputPacket;
import com.dc.eai.conv.OutputPacket;
import com.dc.eai.conv.fieldconv.DefaultFieldConverter;
import com.dc.eai.data.CompositeData;
import com.dc.eai.data.Field;
import com.dc.eai.data.FieldAttr;
import com.dc.eai.data.FieldType;
import com.dc.util.NumberUtils;
import com.dc.util.pack.PackUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StringFieldConverter
extends DefaultFieldConverter {
    private static Log log = LogFactory.getLog((Class)StringFieldConverter.class);
    private String encoding = "gbk";
    private char fill_char = (char)32;
    private boolean left_align = true;
    private boolean with_digit = true;
    private boolean with_plus_sign = false;
    private int radix = 10;

    public StringFieldConverter() {
        super("String");
    }

    public void unpack(InputPacket packet, CompositeData data, FieldIOConfig config) {
        FieldType ftype = config.getType();
        int length = config.getLength();
        if (log.isDebugEnabled()) {
            log.debug((Object)("********begin \uff1a offset = " + packet.getOffset()));
        }
        if (FieldType.integerType(ftype)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"******** \u5bf9\u6574\u578b\u8fdb\u884c\u62c6\u5305");
            }
            FieldAttr fattr = new FieldAttr(ftype, length);
            Field value = new Field(fattr);
            byte[] buff = packet.getBuff();
            int offset = packet.getOffset();
            if (this.with_plus_sign) {
                ++length;
            } else {
                if (packet.exceed(1)) {
                    throw this.PacketLenOverflowException(packet, 1);
                }
                if (buff[offset] == 45 || buff[offset] == 43) {
                    ++length;
                }
            }
            if (packet.exceed(length)) {
                throw this.PacketLenOverflowException(packet, length);
            }
            long l = NumberUtils.longValue(buff, offset, length);
            packet.advance(length);
            value.setValue(new Long(l));
            data.addField(config.getName(), value);
        } else if (FieldType.decimalType(ftype)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"******** \u5bf9\u6d6e\u70b9\u578b\u8fdb\u884c\u62c6\u5305");
            }
            int scale = config.getScale();
            FieldAttr fattr = new FieldAttr(ftype, length, scale);
            Field value = new Field(fattr);
            byte[] buff = packet.getBuff();
            int offset = packet.getOffset();
            if (this.with_plus_sign) {
                ++length;
            } else {
                if (packet.exceed(1)) {
                    throw this.PacketLenOverflowException(packet, 1);
                }
                if (buff[offset] == 45 || buff[offset] == 43) {
                    ++length;
                }
            }
            if (this.with_digit) {
                ++length;
            }
            if (packet.exceed(length)) {
                throw this.PacketLenOverflowException(packet, length);
            }
            double d = this.with_digit ? NumberUtils.doubleValue(buff, offset, length) : NumberUtils.doubleValue(buff, offset, length, fattr.getScale());
            packet.advance(length);
            value.setValue(new Double(d));
            data.addField(config.getName(), value);
        } else if (ftype == FieldType.FIELD_STRING) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"******** \u5bf9\u5b57\u7b26\u4e32\u8fdb\u884c\u62c6\u5305");
            }
            FieldAttr fattr = new FieldAttr(ftype, length);
            Field value = new Field(fattr);
            if (length == 0) {
                value.setValue("");
                data.addField(config.getName(), value);
                return;
            }
            if (packet.exceed(length)) {
                throw this.PacketLenOverflowException(packet, length);
            }
            String str = PackUtils.get_string_untrim(packet.getBuff(), packet.getOffset(), length, this.encoding);
            packet.advance(length);
            value.setValue(str);
            data.addField(config.getName(), value);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"******** \u5176\u5b83\u7c7b\u578b\uff0c\u8c03\u7528Default\u65b9\u5f0f\u8fdb\u884c\u62c6\u5305");
            }
            super.unpack(packet, data, config);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("******** Type = " + ftype + ", Value = " + data.getField(config.getName())));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"******** \u57df\u62c6\u5305(String\u65b9\u5f0f)\u7ed3\u675f");
        }
    }

    public void pack(OutputPacket packet, CompositeData data, FieldIOConfig config) {
        Field value = data.getField(config.getName());
        if (value.getValue() == null) {
            return;
        }
        FieldType ftype = config.getType();
        if (log.isDebugEnabled()) {
            log.debug((Object)"******** \u57df\u6253\u5305(String\u65b9\u5f0f)\u5f00\u59cb");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("******** Type = " + ftype + ", Value = " + data.getField(config.getName())));
        }
        if (FieldType.integerType(ftype)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"******** \u5bf9\u6574\u578b\u8fdb\u884c\u6253\u5305");
            }
            int length = config.getLength();
            long l = value.longValue();
            if (this.with_plus_sign || l < 0L) {
                ++length;
            }
            packet.ensure(length);
            NumberUtils.toBytes(packet.getBuff(), packet.getOffset(), l, config.getLength(), this.with_plus_sign);
            packet.advance(length);
        } else if (FieldType.decimalType(ftype)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"******** \u5bf9\u6d6e\u70b9\u578b\u8fdb\u884c\u6253\u5305");
            }
            int length = config.getLength();
            double d = value.doubleValue();
            if (this.with_plus_sign || d < 0.0) {
                ++length;
            }
            if (this.with_digit) {
                ++length;
            }
            packet.ensure(length);
            NumberUtils.toBytes(packet.getBuff(), packet.getOffset(), d, config.getLength(), config.getScale(), this.with_digit, this.with_plus_sign);
            packet.advance(length);
        } else if (ftype == FieldType.FIELD_STRING) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"******** \u5bf9\u5b57\u7b26\u4e32\u8fdb\u884c\u6253\u5305");
            }
            String str = value.strValue();
            int length = config.getLength();
            packet.ensure(length);
            PackUtils.put_string(packet.getBuff(), packet.getOffset(), str, length, this.encoding, this.fill_char, this.left_align);
            packet.advance(length);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"******** \u5176\u5b83\u7c7b\u578b\uff0c\u8c03\u7528Default\u65b9\u5f0f\u8fdb\u884c\u6253\u5305");
            }
            super.pack(packet, data, config);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("******** Packet = " + packet.getBuff()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"******** \u57df\u6253\u5305(String\u65b9\u5f0f)\u7ed3\u675f");
        }
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setFillChar(char fill_char) {
        this.fill_char = fill_char;
    }

    public void setLeftAlign(boolean left_align) {
        this.left_align = left_align;
    }

    public void setWithDigit(boolean with_digit) {
        this.with_digit = with_digit;
    }

    public void setWithPlusSign(boolean with_plus_sign) {
        this.with_plus_sign = with_plus_sign;
    }

    public void setRadix(int radix) {
        this.radix = radix;
    }
}

