/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.conv.fieldconv;

import com.dc.eai.config.FieldIOConfig;
import com.dc.eai.conv.InputPacket;
import com.dc.eai.conv.OutputPacket;
import com.dc.eai.conv.fieldconv.DefaultFieldConverter;
import com.dc.eai.data.CompositeData;
import com.dc.eai.data.Field;
import com.dc.eai.data.FieldAttr;
import com.dc.eai.data.FieldType;
import com.dc.util.pack.PackUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StandardFieldConverter
extends DefaultFieldConverter {
    private static Log log = LogFactory.getLog((Class)StandardFieldConverter.class);
    private String encoding = "gbk";
    private char fill_char = (char)32;
    private boolean left_align = true;
    private boolean net_order = true;

    public StandardFieldConverter() {
        super("Standard");
    }

    public void unpack(InputPacket packet, CompositeData data, FieldIOConfig config) {
        FieldType ftype = config.getType();
        if (log.isDebugEnabled()) {
            log.debug((Object)("******** \u57df\u62c6\u5305(Standard\u65b9\u5f0f)\u5f00\u59cb\uff1aoffset = " + packet.getOffset()));
        }
        if (FieldType.integerType(ftype)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"******** \u5bf9\u6574\u578b\u8fdb\u884c\u62c6\u5305");
            }
            if (FieldType.FIELD_BYTE == ftype) {
                int length = 1;
                Field value = new Field(new FieldAttr(ftype, length));
                if (packet.exceed(length)) {
                    throw this.PacketLenOverflowException(packet, length);
                }
                byte val = PackUtils.get_int8(packet.getBuff(), packet.getOffset());
                packet.advance(length);
                value.setValue(new Byte(val));
                data.addField(config.getName(), value);
            } else if (FieldType.FIELD_SHORT == ftype) {
                int length = 2;
                Field value = new Field(new FieldAttr(ftype, length));
                if (packet.exceed(length)) {
                    throw this.PacketLenOverflowException(packet, length);
                }
                short val = PackUtils.get_int16(packet.getBuff(), packet.getOffset(), this.net_order);
                packet.advance(length);
                value.setValue(new Short(val));
                data.addField(config.getName(), value);
            } else if (FieldType.FIELD_INT24 == ftype) {
                int length = 3;
                Field value = new Field(new FieldAttr(ftype, length));
                if (packet.exceed(length)) {
                    throw this.PacketLenOverflowException(packet, length);
                }
                int val = PackUtils.get_int24(packet.getBuff(), packet.getOffset(), this.net_order);
                packet.advance(length);
                value.setValue(new Integer(val));
                data.addField(config.getName(), value);
            } else if (FieldType.FIELD_INT == ftype) {
                int length = 4;
                Field value = new Field(new FieldAttr(ftype, length));
                if (packet.exceed(length)) {
                    throw this.PacketLenOverflowException(packet, length);
                }
                int val = PackUtils.get_int32(packet.getBuff(), packet.getOffset(), this.net_order);
                packet.advance(length);
                value.setValue(new Integer(val));
                data.addField(config.getName(), value);
            } else if (FieldType.FIELD_LONG == ftype) {
                int length = 8;
                Field value = new Field(new FieldAttr(ftype, length));
                if (packet.exceed(length)) {
                    throw this.PacketLenOverflowException(packet, length);
                }
                long val = PackUtils.get_int64(packet.getBuff(), packet.getOffset(), this.net_order);
                packet.advance(length);
                value.setValue(new Long(val));
                data.addField(config.getName(), value);
            }
        } else if (FieldType.decimalType(ftype)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"******** \u5bf9\u6d6e\u70b9\u578b\u8fdb\u884c\u62c6\u5305");
            }
            if (FieldType.FIELD_FLOAT == ftype) {
                int length = 4;
                int scale = config.getScale();
                Field value = new Field(new FieldAttr(ftype, length, scale));
                if (packet.exceed(length)) {
                    throw this.PacketLenOverflowException(packet, length);
                }
                float val = PackUtils.get_float(packet.getBuff(), packet.getOffset(), this.net_order);
                packet.advance(length);
                value.setValue(new Float(val));
                data.addField(config.getName(), value);
            } else if (FieldType.FIELD_DOUBLE == ftype) {
                int length = 8;
                int scale = config.getScale();
                Field value = new Field(new FieldAttr(ftype, length, scale));
                if (packet.exceed(length)) {
                    throw this.PacketLenOverflowException(packet, length);
                }
                double val = PackUtils.get_double(packet.getBuff(), packet.getOffset(), this.net_order);
                packet.advance(length);
                value.setValue(new Double(val));
                data.addField(config.getName(), value);
            }
        } else if (ftype == FieldType.FIELD_STRING) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"******** \u5bf9\u5b57\u7b26\u4e32\u8fdb\u884c\u62c6\u5305");
            }
            int length = config.getLength();
            Field value = new Field(new FieldAttr(ftype, length));
            if (packet.exceed(length)) {
                throw this.PacketLenOverflowException(packet, length);
            }
            String str = PackUtils.get_string(packet.getBuff(), packet.getOffset(), length, this.encoding, this.fill_char, this.left_align);
            packet.advance(length);
            value.setValue(str);
            data.addField(config.getName(), value);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"******** \u5bf9IMAGE\u578b\uff0c\u8c03\u7528Default\u65b9\u5f0f\u8fdb\u884c\u62c6\u5305");
            }
            super.unpack(packet, data, config);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("******** Type = " + ftype + ", Value = " + data.getField(config.getName())));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"******** \u57df\u62c6\u5305(Standard\u65b9\u5f0f)\u7ed3\u675f");
        }
    }

    public void pack(OutputPacket packet, CompositeData data, FieldIOConfig config) {
        Field value;
        if (log.isDebugEnabled()) {
            log.debug((Object)"******** \u57df\u6253\u5305(Standard\u65b9\u5f0f)\u5f00\u59cb");
        }
        if ((value = data.getField(config.getName())).getValue() == null) {
            return;
        }
        FieldType ftype = config.getType();
        if (log.isDebugEnabled()) {
            log.debug((Object)("******** Type = " + ftype + ", Value = " + data.getField(config.getName())));
        }
        if (FieldType.integerType(ftype)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"******** \u5bf9\u6574\u578b\u8fdb\u884c\u6253\u5305");
            }
            if (FieldType.FIELD_BYTE == ftype) {
                int length = 1;
                packet.ensure(length);
                PackUtils.put_int8(packet.getBuff(), packet.getOffset(), value.byteValue());
                packet.advance(length);
            } else if (FieldType.FIELD_SHORT == ftype) {
                int length = 2;
                packet.ensure(length);
                PackUtils.put_int16(packet.getBuff(), packet.getOffset(), value.shortValue(), this.net_order);
                packet.advance(length);
            } else if (FieldType.FIELD_INT24 == ftype) {
                int length = 3;
                packet.ensure(length);
                PackUtils.put_int24(packet.getBuff(), packet.getOffset(), value.intValue(), this.net_order);
                packet.advance(length);
            } else if (FieldType.FIELD_INT == ftype) {
                int length = 4;
                packet.ensure(length);
                PackUtils.put_int32(packet.getBuff(), packet.getOffset(), value.intValue(), this.net_order);
                packet.advance(length);
            } else if (FieldType.FIELD_LONG == ftype) {
                int length = 8;
                packet.ensure(length);
                PackUtils.put_int64(packet.getBuff(), packet.getOffset(), value.longValue(), this.net_order);
                packet.advance(length);
            }
        } else if (FieldType.decimalType(ftype)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"******** \u5bf9\u6d6e\u70b9\u578b\u8fdb\u884c\u6253\u5305");
            }
            if (FieldType.FIELD_FLOAT == ftype) {
                int length = 4;
                packet.ensure(length);
                PackUtils.put_float(packet.getBuff(), packet.getOffset(), value.floatValue(), this.net_order);
                packet.advance(length);
            } else if (FieldType.FIELD_DOUBLE == ftype) {
                int length = 8;
                packet.ensure(length);
                PackUtils.put_double(packet.getBuff(), packet.getOffset(), value.doubleValue(), this.net_order);
                packet.advance(length);
            }
        } else if (ftype == FieldType.FIELD_STRING) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"******** \u5bf9\u5b57\u7b26\u4e32\u8fdb\u884c\u6253\u5305");
            }
            String str = value.strValue();
            int length = config.getLength();
            packet.ensure(length);
            PackUtils.put_string(packet.getBuff(), packet.getOffset(), str, length, this.encoding, this.fill_char, this.left_align);
            packet.advance(length);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"******** \u5bf9IMAGE\u578b\uff0c\u8c03\u7528Default\u65b9\u5f0f\u8fdb\u884c\u6253\u5305");
            }
            super.pack(packet, data, config);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("******** Packet = " + packet.getBuff()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"******** \u57df\u6253\u5305(Standard\u65b9\u5f0f)\u7ed3\u675f");
        }
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setFillChar(char fill_char) {
        this.fill_char = fill_char;
    }

    public void setLeftAlign(boolean left_align) {
        this.left_align = left_align;
    }

    public void setNetOrder(boolean net_order) {
        this.net_order = net_order;
    }
}

