/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.conv.fieldconv;

import com.dc.eai.config.FieldIOConfig;
import com.dc.eai.conv.InputPacket;
import com.dc.eai.conv.OutputPacket;
import com.dc.eai.conv.fieldconv.DefaultFieldConverter;
import com.dc.eai.data.CompositeData;
import com.dc.eai.data.Field;
import com.dc.eai.data.FieldAttr;
import com.dc.eai.data.FieldType;
import com.dc.util.pack.PackUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PackDecimalFieldConverter
extends DefaultFieldConverter {
    private static Log log = LogFactory.getLog((Class)PackDecimalFieldConverter.class);

    public PackDecimalFieldConverter() {
        super("PackDecimal");
    }

    public void unpack(InputPacket packet, CompositeData data, FieldIOConfig config) {
        FieldType ftype = config.getType();
        int length = config.getLength();
        if (log.isDebugEnabled()) {
            log.debug((Object)"******** \u57df\u62c6\u5305(PackDecimal\u65b9\u5f0f)\u5f00\u59cb");
        }
        if (FieldType.numberType(ftype)) {
            Field value;
            if (log.isDebugEnabled()) {
                log.debug((Object)"******** \u5bf9\u6570\u503c\u7c7b\u578b\u8fdb\u884c\u62c6\u5305");
            }
            int scale = config.getScale();
            int total = length / 2 + 1;
            if (packet.exceed(total)) {
                throw this.PacketLenOverflowException(packet, total);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("******** Buff = " + packet.getBuff() + ", Offset = " + packet.getOffset() + ", Length = " + config.getLength() + ", Scale = " + config.getScale()));
            }
            double val = PackUtils.get_pack_decimal(packet.getBuff(), packet.getOffset(), length, scale);
            if (log.isDebugEnabled()) {
                log.debug((Object)("******** value = " + val));
            }
            if (FieldType.decimalType(ftype)) {
                value = new Field(new FieldAttr(ftype, length, scale));
                value.setValue(new Double(val));
            } else {
                value = new Field(new FieldAttr(ftype, length));
                value.setValue(new Long((long)val));
            }
            data.addField(config.getName(), value);
            packet.advance(total);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"******** \u975e\u6570\u503c\u7c7b\u578b\uff0c\u8c03\u7528Default\u65b9\u5f0f\u8fdb\u884c\u62c6\u5305");
            }
            super.unpack(packet, data, config);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"******** \u57df\u62c6\u5305(PackDecimal\u65b9\u5f0f)\u7ed3\u675f");
        }
    }

    public void pack(OutputPacket packet, CompositeData data, FieldIOConfig config) {
        Field value;
        if (log.isDebugEnabled()) {
            log.debug((Object)"******** \u57df\u6253\u5305(PackDecimal\u65b9\u5f0f)\u5f00\u59cb");
        }
        if ((value = data.getField(config.getName())).getValue() == null) {
            return;
        }
        FieldType ftype = config.getType();
        if (FieldType.numberType(ftype)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"******** \u5bf9\u6570\u503c\u7c7b\u578b\u8fdb\u884c\u6253\u5305");
            }
            int length = config.getLength();
            int scale = config.getScale();
            int total = length / 2 + 1;
            packet.ensure(total);
            PackUtils.put_pack_decimal(packet.getBuff(), packet.getOffset(), value.doubleValue(), length, scale);
            if (log.isDebugEnabled()) {
                log.debug((Object)("******** Buff = " + packet.getBuff() + ", Offset = " + packet.getOffset() + ", Length = " + config.getLength() + ", Scale = " + config.getScale() + ", Value = " + value.doubleValue()));
            }
            packet.advance(total);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"******** \u975e\u6570\u503c\u7c7b\u578b\uff0c\u8c03\u7528Default\u65b9\u5f0f\u8fdb\u884c\u6253\u5305");
            }
            super.pack(packet, data, config);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"******** \u57df\u6253\u5305(PackDecimal\u65b9\u5f0f)\u7ed3\u675f");
        }
    }
}

