/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.conv.fieldconv;

import com.dc.eai.config.FieldIOConfig;
import com.dc.eai.conv.DataConvertException;
import com.dc.eai.conv.FieldConverter;
import com.dc.eai.conv.InputPacket;
import com.dc.eai.conv.OutputPacket;
import com.dc.eai.conv.Packet;
import com.dc.eai.data.CompositeData;
import com.dc.eai.data.Field;
import com.dc.eai.data.FieldAttr;
import com.dc.eai.data.FieldType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class DefaultFieldConverter
implements FieldConverter {
    private static Log log = LogFactory.getLog((Class)DefaultFieldConverter.class);
    protected String name;

    public DefaultFieldConverter(String name) {
        this.name = name;
    }

    public void unpack(InputPacket packet, CompositeData data, FieldIOConfig config) {
        FieldType ftype = config.getType();
        if (ftype == FieldType.FIELD_IMAGE) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"******** \u57df\u62c6\u5305(Default\u65b9\u5f0f)\u5f00\u59cb");
            }
            int length = config.getLength();
            Field value = new Field(new FieldAttr(ftype, length));
            if (log.isDebugEnabled()) {
                log.debug((Object)("******** Buff = " + packet.getBuff() + ", Offset = " + packet.getOffset() + ", Length = " + config.getLength()));
            }
            if (packet.exceed(length)) {
                throw this.PacketLenOverflowException(packet, length);
            }
            byte[] bv = new byte[length];
            System.arraycopy(packet.getBuff(), packet.getOffset(), bv, 0, length);
            packet.advance(length);
            value.setValue(bv);
            data.addField(config.getName(), value);
            if (log.isDebugEnabled()) {
                log.debug((Object)("******** " + config.getName() + " = " + data.getField(config.getName())));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"******** \u57df\u62c6\u5305(Default\u65b9\u5f0f)\u7ed3\u675f");
            }
        } else {
            throw this.UnpackDataInvalidException(packet, ftype.toString());
        }
    }

    public void pack(OutputPacket packet, CompositeData data, FieldIOConfig config) {
        FieldType ftype = config.getType();
        if (ftype == FieldType.FIELD_IMAGE) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"******** \u57df\u6253\u5305(Default\u65b9\u5f0f)\u5f00\u59cb");
            }
            int length = config.getLength();
            packet.ensure(length);
            Field value = data.getField(config.getName());
            if (log.isDebugEnabled()) {
                log.debug((Object)("******** " + config.getName() + " = " + value));
            }
            System.arraycopy(value.imageValue(), 0, packet.getBuff(), packet.getOffset(), length);
            if (log.isDebugEnabled()) {
                log.debug((Object)("******** Buff = " + packet.getBuff() + ", Offset = " + packet.getOffset() + ", Length = " + config.getLength()));
            }
            packet.advance(length);
            if (log.isDebugEnabled()) {
                log.debug((Object)"******** \u57df\u6253\u5305(Default\u65b9\u5f0f)\u7ed3\u675f");
            }
        } else {
            throw this.PackDataInvalidException(packet, ftype.toString());
        }
    }

    protected RuntimeException UnpackDataInvalidException(Packet packet, String dest) {
        DataConvertException e = new DataConvertException("unpack_data_invalid");
        e.addScene("Packet", packet);
        e.addScene("Current", packet.getOffset());
        e.addScene("From", this.name);
        e.addScene("To", dest);
        return e;
    }

    protected RuntimeException PackDataInvalidException(Packet packet, String source) {
        DataConvertException e = new DataConvertException("PackDataInvalid");
        e.addScene("Packet", packet);
        e.addScene("Current", packet.getOffset());
        e.addScene("From", source);
        e.addScene("To", this.name);
        return e;
    }

    protected RuntimeException PacketLenOverflowException(Packet packet, int length) {
        DataConvertException e = new DataConvertException("PacketLenOverflow");
        e.addScene("Packet", packet);
        e.addScene("Current", packet.getOffset());
        e.addScene("RequestLen", length);
        return e;
    }
}

