/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.conv;

import com.dc.eai.config.DataDictionary;
import com.dc.eai.config.DictionaryItem;
import com.dc.eai.config.MapperConfig;
import com.dc.eai.conv.DataMapper;
import com.dc.eai.data.Array;
import com.dc.eai.data.AtomData;
import com.dc.eai.data.CompositeData;
import com.dc.eai.data.CompositeDataSet;
import com.dc.eai.data.Field;
import com.dc.eai.data.FieldAttr;
import com.dc.eai.data.FieldType;
import com.dc.eai.util.CompositeDataHelper;
import com.dc.expr.CompositeDataExprData;
import com.dc.expr.Exp;
import com.dc.expr.ExpType;
import com.dc.expr.ExprException;
import com.dc.expr.NotFoundExprException;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ExpressionDataMapper
implements DataMapper {
    private static Log log = LogFactory.getLog((Class)ExpressionDataMapper.class);
    private MapperConfig config;

    public ExpressionDataMapper(MapperConfig config) {
        this.config = config;
    }

    public ExpressionDataMapper() {
    }

    public void map(CompositeDataSet set, CompositeData dest) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"******** \u6620\u5c04\u5f00\u59cb");
        }
        int size = this.config.size();
        this.cpBase(set, dest);
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u5171\u6709 [" + size + "] \u4e2a\u6761\u76ee"));
        }
        if (size == 0) {
            return;
        }
        String tempName = "temp";
        set.putData(tempName, dest);
        CompositeDataExprData exprData = new CompositeDataExprData(set);
        for (int i = 0; i < size; ++i) {
            Exp exp;
            String itemName = this.config.getItemName(i);
            Exp valueExp = this.config.getItemValue(i);
            int index = itemName.lastIndexOf("@");
            if (index > 0) {
                String attr = itemName.substring(index + 1);
                try {
                    Exp exp2 = valueExp.eval(exprData);
                    AtomData atom = dest.getObject(itemName.substring(0, index));
                    if (atom == null) {
                        if (!log.isWarnEnabled()) continue;
                        log.warn((Object)("" + itemName.substring(0, index) + ": \u4e0d\u5b58\u5728\uff0c\u8df3\u8fc7"));
                        continue;
                    }
                    atom.setAttribute(attr, exp2.strValue());
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)(itemName + "\t= {" + exp2.strValue() + "}"));
                }
                catch (ExprException e) {
                    if (!log.isErrorEnabled()) continue;
                    log.error((Object)("\u8868\u8fbe\u5f0f[" + i + "]\u6620\u5c04\u51fa\u9519\uff0c\u540d\u5b57\uff1a" + itemName), (Throwable)e);
                }
                continue;
            }
            if (index == 0) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)(itemName + ": \u540d\u79f0\u975e\u6cd5\uff0c\u8df3\u8fc7"));
                continue;
            }
            try {
                exp = valueExp.eval(exprData);
            }
            catch (ExprException exe) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)(exe.errCode() + itemName + "\u8868\u8fbe\u5f0f\u8ba1\u7b97\u5931\u8d25"), (Throwable)exe);
                continue;
            }
            catch (NotFoundExprException nfe) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)(nfe.errCode() + itemName));
                continue;
            }
            try {
                if (exp.getType() == ExpType.OBJECT_TYPE) {
                    AtomData destValue;
                    Object obj = exp.objectValue();
                    if (obj instanceof CompositeData) {
                        destValue = new CompositeData();
                        CompositeDataHelper.shadowCopy((CompositeData)exp.objectValue(), destValue);
                        dest.addStruct(itemName, (CompositeData)destValue);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)(itemName + " = {\n" + destValue + "}"));
                        continue;
                    }
                    if (obj instanceof Array) {
                        destValue = new Array();
                        CompositeDataHelper.deepCopy((Array)exp.objectValue(), (Array)destValue);
                        dest.addArray(itemName, (Array)destValue);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)(itemName + " = {\n" + destValue + "}"));
                        continue;
                    }
                    if (!(obj instanceof Field)) continue;
                    Field source = (Field)obj;
                    Field destValue2 = new Field(source.getAttr());
                    CompositeDataHelper.deepCopy(source, destValue2);
                    dest.addField(itemName, destValue2);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)(itemName + " = {\n" + destValue2 + "}"));
                    continue;
                }
                if (itemName.startsWith("##")) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("\u586b\u5145\u62a5\u6587\uff1a" + itemName + "\t Index: " + i + " }"));
                    continue;
                }
                Field fvalue = null;
                Object obj = null;
                DataDictionary dict = DataDictionary.instance();
                DictionaryItem ditem = dict.getItem(this.splitField(itemName));
                fvalue = new Field(new FieldAttr(ditem.getType(), ditem.getLength(), ditem.getScale()));
                FieldType ftype = fvalue.getFieldType();
                if (ftype == null) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)(itemName + "\u5728\u6570\u636e\u5b57\u5178\u4e0d\u5b58\u5728\uff01"));
                    continue;
                }
                if (FieldType.FIELD_SHORT == ftype) {
                    fvalue.setValue(new Integer(exp.intValue()).shortValue());
                } else if (FieldType.FIELD_BYTE == ftype) {
                    fvalue.setValue(new Integer(exp.intValue()).shortValue());
                } else if (FieldType.FIELD_INT24 == ftype) {
                    fvalue.setValue(new Integer(exp.intValue()).longValue());
                } else if (FieldType.FIELD_INT == ftype) {
                    fvalue.setValue(exp.intValue());
                } else if (FieldType.FIELD_LONG == ftype) {
                    fvalue.setValue(new Integer(exp.intValue()).longValue());
                } else if (FieldType.FIELD_FLOAT == ftype) {
                    fvalue.setValue(new Double(exp.doubleValue()).floatValue());
                } else if (FieldType.FIELD_DOUBLE == ftype) {
                    fvalue.setValue((double)new Double(exp.doubleValue()));
                } else if (ftype == FieldType.FIELD_STRING) {
                    fvalue.setValue(exp.strValue());
                } else if (ftype == FieldType.FIELD_IMAGE) {
                    fvalue.setValue(exp.imageValue());
                }
                dest.addField(itemName, fvalue);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)(itemName + "\t= {" + fvalue.getValue() + "}"));
                continue;
            }
            catch (NullPointerException ne) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)(itemName + "\u9700\u8981\u7684\u57df\u4e0d\u5b58\u5728\uff0c\u6b64\u9879\u6620\u5c04\u5931\u8d25"));
                continue;
            }
            catch (ExprException ee) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)(itemName + "\u9700\u8981\u7684\u57df\u4e0d\u5b58\u5728\uff0c\u6b64\u9879\u6620\u5c04\u5931\u8d25"));
            }
        }
        set.removeData(tempName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u6620\u5c04\u7ed3\u679c\uff1a\n" + dest));
        }
    }

    public void map(CompositeData src, CompositeData dest) {
        CompositeDataSet set = new CompositeDataSet();
        set.putData("in", src);
        this.map(set, dest);
    }

    private String splitField(String fullname) {
        String temp = fullname.substring(fullname.lastIndexOf(".") + 1);
        int index = temp.lastIndexOf("[");
        if (index < 0) {
            return temp;
        }
        return temp.substring(0, index);
    }

    private void cpBase(CompositeDataSet dataset, CompositeData data) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"******** cpBase\u5f00\u59cb ");
        }
        if (this.config.baseSize() == 0) {
            CompositeDataHelper.shadowCopy(dataset.getData("in"), data);
        }
        for (int i = 0; i < this.config.baseSize(); ++i) {
            String base = this.config.getBase(i);
            CompositeData temp = dataset.getData(base);
            log.debug((Object)("base[" + i + "] : " + base));
            if (temp != null) {
                CompositeDataHelper.shadowCopy(temp, data);
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("********\u4e0d\u5b58\u5728CompositeData,\u5176\u540d\u5b57\u4e3a" + this.config.getBase(i)));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"******** cpBase\u7ed3\u675f");
        }
    }

    private void clearTempFields(CompositeData data) {
        Iterator it = data.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            if (!name.startsWith("##")) continue;
            data.removeObject(name);
        }
    }

    public void setMapperConfig(MapperConfig config) {
        this.config = config;
    }
}

