/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.config;

import com.dc.expr.Exp;
import com.dc.expr.Expr;
import java.util.ArrayList;
import java.util.List;

public final class MapperConfig {
    private final List items = new ArrayList(101);
    private final List base = new ArrayList(11);
    private boolean overwrite = true;

    public void addItem(String name, String value) {
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("mapping item name is NULL or null String");
        }
        MapperItem item = new MapperItem(name, Expr.compile(value));
        this.items.add(item);
    }

    public String getItemName(int i) {
        return ((MapperItem)this.items.get((int)i)).name;
    }

    public Exp getItemValue(int i) {
        return ((MapperItem)this.items.get((int)i)).val;
    }

    public void removeItem(int i) {
        this.items.remove(i);
    }

    public int size() {
        return this.items.size();
    }

    public void addBase(String s) {
        this.base.add(s);
    }

    public String getBase(int i) {
        return (String)this.base.get(i);
    }

    public void removeBase(int i) {
        this.base.remove(i);
    }

    public int baseSize() {
        return this.base.size();
    }

    public void setOverwrite(boolean b) {
        this.overwrite = b;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    private final class MapperItem {
        String name;
        Exp val;

        MapperItem(String name, Exp value) {
            this.name = name;
            this.val = value;
        }
    }
}

