/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.client;

import com.dc.eai.adapter.AdapterReceiveDataException;
import com.dc.eai.adapter.AdapterSendDataException;
import com.dc.eai.adapter.tcp.TCPException;
import com.dc.eai.adapter.tcp.TCPSocket;
import com.dc.eai.config.AdapterConfig;
import com.dc.util.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SocketChannel {
    private static Log log = LogFactory.getLog((Class)SocketChannel.class);
    private AdapterConfig config;
    private TCPSocket tcpsock;
    private int mode = 0;
    private String address;
    private int commport;
    private int timeout;
    private int maxbytes;

    public SocketChannel(byte[] request, AdapterConfig config) {
        this.config = config;
        this.mode = NumberUtils.intValue(config.getAttribute("mode"));
        this.address = config.getAttribute("address");
        this.commport = NumberUtils.intValue(config.getAttribute("commport"));
        this.timeout = NumberUtils.intValue(config.getAttribute("timeout"));
        this.maxbytes = NumberUtils.intValue(config.getAttribute("maxbytes"));
        this.tcpsock = new TCPSocket(this.address, this.commport, this.timeout, this.maxbytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doComm(Object request) {
        byte[] in = (byte[])request;
        byte[] out = null;
        if (this.mode == 0) {
            try {
                this.tcpsock.connect();
                this.writepacket(this.tcpsock, in);
                byte[] byArray = out = this.readpacket(this.tcpsock);
                return byArray;
            }
            catch (TCPException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"doComm() error", (Throwable)e);
                }
                e.printStackTrace();
            }
            finally {
                this.tcpsock.close();
            }
        }
        return null;
    }

    private byte[] readpacket(TCPSocket tcpsock) {
        try {
            return tcpsock.recv();
        }
        catch (TCPException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"\u8bfb\u6570\u636e\u51fa\u9519", (Throwable)e);
            }
            throw new AdapterReceiveDataException(e);
        }
    }

    private void writepacket(TCPSocket tcpsock, byte[] buff) {
        try {
            tcpsock.send(buff);
        }
        catch (TCPException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"\u5199\u6570\u636e\u51fa\u9519", (Throwable)e);
            }
            throw new AdapterSendDataException(e);
        }
    }

    public AdapterConfig getConfig() {
        return this.config;
    }
}

