/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.client;

import com.dc.eai.client.SCCommand;
import com.dc.eai.client.SocketChannel;
import com.dc.eai.config.AdapterConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClientConsole {
    private static Log log = LogFactory.getLog((Class)ClientConsole.class);
    private static String msgid = "";
    private static String port = "7900";
    private static String host = "127.0.0.1";
    private static String dispatcher = "normal-dispatcher";

    public static Map commandMap() {
        HashMap<String, String> cmdList = new HashMap<String, String>();
        cmdList.put("AutoMK", "1");
        cmdList.put("HandMK", "2");
        cmdList.put("CreateNode", "3");
        cmdList.put("SelectNode", "4");
        cmdList.put("DeleteNode", "5");
        cmdList.put("SendNode", "6");
        cmdList.put("GetCheckValue", "7");
        cmdList.put("RequestKey", "8");
        cmdList.put("help", "9");
        cmdList.put("exit", "10");
        String mark = System.getProperty("mark");
        if (mark == null || "".equals(mark)) {
            mark = "false";
        }
        if (mark.equalsIgnoreCase("true")) {
            cmdList.remove("RequestKey");
        } else {
            cmdList.remove("CreateNode");
            cmdList.remove("SendNode");
            cmdList.remove("DeleteNode");
            cmdList.remove("SeleteNode");
        }
        return cmdList;
    }

    public static void testSingle(String msgname) {
        if (msgname.equals("help")) {
            System.out.println("\u547d\u4ee4\u5217\u8868");
            ClientConsole.printHelp();
        } else {
            byte[] input = msgname.getBytes();
            int len = input.length;
            String blen = String.valueOf(len);
            while (blen.length() < 10) {
                blen = "0" + blen;
            }
            String temp1 = blen + new String(input);
            input = temp1.getBytes();
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u62a5\u6587\u5f00\u59cb\u53d1\u9001");
            }
            String result = ClientConsole.sendMsg(input);
            if (msgname.startsWith("Security03")) {
                String keyMsg = result.substring(0, 32);
                String nodeip = result.substring(32, 47);
                String nodeattr = result.substring(47, 48);
                String nodemark = result.substring(48);
                if (nodeattr.equalsIgnoreCase("1")) {
                    nodeattr = "\u662f";
                    keyMsg = keyMsg + "\r\n\u8282   \u70b9  IP: " + nodeip + "\r\n\u662f\u5426\u4e2d\u5fc3\u8282\u70b9: " + nodeattr + "\r\n\u63cf        \u8ff0: " + nodemark;
                } else if (nodeattr.equalsIgnoreCase("0")) {
                    nodeattr = "\u5426";
                    keyMsg = keyMsg + "\r\n\u8282   \u70b9  IP: " + nodeip + "\r\n\u662f\u5426\u4e2d\u5fc3\u8282\u70b9: " + nodeattr + "\r\n\u63cf        \u8ff0: " + nodemark;
                } else {
                    nodeattr = "";
                }
                System.out.println(keyMsg);
            } else {
                System.out.println(result);
            }
        }
    }

    private static String sendMsg(byte[] req) {
        int i;
        String hosti;
        String porti = System.getProperty("port");
        if (porti != null) {
            port = porti;
        }
        if ((hosti = System.getProperty("host")) != null) {
            host = hosti;
        }
        AdapterConfig config = new AdapterConfig();
        config.setAttribute("address", host);
        config.setAttribute("commport", port);
        config.setAttribute("timeout", "300000");
        config.setAttribute("dispatcher", dispatcher);
        config.setAttribute("maxbytes", "20480");
        config.setAttribute("mode", "0");
        config.setAttribute("endmode", "0");
        config.setAttribute("prelength", "2");
        config.setAttribute("includepre", "0");
        config.setAttribute("includelength", "0");
        SocketChannel sc = new SocketChannel(req, config);
        byte[] resp = (byte[])sc.doComm(req);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (i = 0; i < resp.length && resp[i] != 0; ++i) {
            arrayList.add(new Integer(resp[i]));
        }
        byte[] buf = new byte[i];
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            buf[i2] = (byte)((Integer)arrayList.get(i2)).intValue();
        }
        return new String(buf);
    }

    public static void main(String[] args) {
        BufferedReader stdIn = new BufferedReader(new InputStreamReader(System.in));
        String cmd = null;
        while (true) {
            try {
                System.out.print("\r\nSC_Client:\\>");
                cmd = stdIn.readLine();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if ((msgid = cmd.trim()) == null || msgid.trim().equals("")) continue;
            if (ClientConsole.checkCommand(msgid)) {
                int idcmd = Integer.parseInt(String.valueOf(ClientConsole.commandMap().get(msgid)));
                String outStr = ClientConsole.sendCommand(idcmd);
                if ("".equals(outStr)) continue;
                ClientConsole.testSingle(outStr);
                continue;
            }
            System.out.println(ClientConsole.noCommandErr(msgid));
        }
    }

    private static String sendCommand(int msgid2) {
        StringBuffer buf = new StringBuffer();
        switch (msgid2) {
            case 1: {
                buf.append(SCCommand.autoMK());
                break;
            }
            case 2: {
                buf.append(SCCommand.handMK());
                break;
            }
            case 3: {
                buf.append(SCCommand.saveNode());
                break;
            }
            case 4: {
                buf.append(SCCommand.selectNode());
                break;
            }
            case 5: {
                buf.append(SCCommand.deleteNode());
                break;
            }
            case 6: {
                buf.append(SCCommand.sendNode());
                break;
            }
            case 7: {
                buf.append(SCCommand.getCheckValue());
                break;
            }
            case 8: {
                buf.append(SCCommand.requestKey());
                break;
            }
            case 9: {
                buf.append(SCCommand.help());
                break;
            }
            case 10: {
                System.out.println("\u786e\u5b9a\u9000\u51fa\u63a7\u5236\u53f0\u5417(Y/N)?");
                BufferedReader stdIn = new BufferedReader(new InputStreamReader(System.in));
                try {
                    String cmd = stdIn.readLine().trim();
                    if (!cmd.equalsIgnoreCase("y")) break;
                    System.exit(0);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break;
            }
        }
        return buf.toString();
    }

    private static String noCommandErr(String msgid2) {
        StringBuffer buf = new StringBuffer();
        buf.append("*********************************\r\n");
        buf.append("***   \u7cfb\u7edf\u4e0d\u80fd\u8bc6\u522b'" + msgid2 + "'\u547d\u4ee4   ***\r\n");
        buf.append("***     \u4f7f\u7528help\u67e5\u770b\u547d\u4ee4\u5217\u8868     ***\r\n");
        buf.append("*********************************\r\n");
        return buf.toString();
    }

    public static boolean checkCommand(String cmd) {
        Map list = ClientConsole.commandMap();
        boolean t = list.containsKey(cmd);
        return t;
    }

    public static void printHelp() {
        Object[] t = ClientConsole.commandMap().keySet().toArray();
        for (int i = 0; i < t.length; ++i) {
            System.out.println("\u547d\u4ee4" + (i + 1) + "--------" + t[i] + "--------");
            System.out.println("+  " + ClientConsole.commandDesc().get(t[i]));
            System.out.println("+--------------------------------");
            System.out.println("");
        }
    }

    public static Map commandDesc() {
        HashMap<String, String> cmdList = new HashMap<String, String>();
        cmdList.put("AutoMK", "\u81ea\u52a8\u751f\u6210\u4e3b\u5bc6\u94a5");
        cmdList.put("HandMK", "\u624b\u52a8\u751f\u6210\u4e3b\u5bc6\u94a5");
        cmdList.put("CreateNode", "\u4fdd\u5b58\u8282\u70b9\u4fe1\u606f");
        cmdList.put("SelectNode", "\u67e5\u8be2\u8282\u70b9\u4fe1\u606f");
        cmdList.put("DeleteNode", "\u5220\u9664\u8282\u70b9\u4fe1\u606f");
        cmdList.put("SendNode", "\u4e0b\u53d1\u8282\u70b9\u4fe1\u606f");
        cmdList.put("GetCheckValue", "\u67e5\u770b\u5bc6\u94a5CV\u503c");
        cmdList.put("RequestKey", "\u8bf7\u6c42\u751f\u6210\u5bc6\u94a5");
        cmdList.put("help", "\u5e2e\u52a9");
        cmdList.put("exit", "\u9000\u51fa\u63a7\u5236\u53f0");
        String mark = System.getProperty("mark");
        if (mark == null || "".equals(mark)) {
            mark = "false";
        }
        if (mark.equalsIgnoreCase("true")) {
            cmdList.remove("RequestKey");
        } else {
            cmdList.remove("CreateNode");
            cmdList.remove("SendNode");
            cmdList.remove("DeleteNode");
            cmdList.remove("SeleteNode");
        }
        return cmdList;
    }
}

