/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.channel.traditional;

import com.dc.eai.channel.Tran;
import com.dc.eai.channel.exception.GetServiceNameException;
import com.dc.eai.channel.exception.IdentifyTranException;
import com.dc.eai.channel.exception.TranDataConvertProcessException;
import com.dc.eai.channel.exception.TranProcessException;
import com.dc.eai.channel.traditional.ChannelSpecialProcess;
import com.dc.eai.config.ChannelConfig;
import com.dc.eai.config.PackageConfig;
import com.dc.eai.config.TranConfig;
import com.dc.eai.conv.ExpressionDataMapper;
import com.dc.eai.conv.InputPacket;
import com.dc.eai.conv.OutputPacket;
import com.dc.eai.conv.PackageConverter;
import com.dc.eai.conv.PackageModeFactory;
import com.dc.eai.data.CompositeData;
import com.dc.eai.data.Field;
import com.dc.eai.data.FieldAttr;
import com.dc.eai.data.FieldType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TraditionalTran
implements Tran {
    private static Log log = LogFactory.getLog((Class)TraditionalTran.class);
    private TranConfig config;
    private InputPacket inpacket;
    private CompositeData headData;
    private ChannelSpecialProcess specialProcess;
    private ChannelConfig channelConfig;

    public TraditionalTran(ChannelSpecialProcess specialProcess, ChannelConfig channelconfig) {
        this.specialProcess = specialProcess;
        this.channelConfig = channelconfig;
    }

    void beforeUnpack(byte[] in) {
        TranConfig tranConfig;
        String tranName;
        byte[] afterProcessBytes;
        if (log.isInfoEnabled()) {
            log.info((Object)"\u6e20\u9053\u5904\u7406-\u4ea4\u6613\u8bc6\u522b\u5f00\u59cb");
        }
        this.headData = new CompositeData();
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u63a5\u5230\u4ea4\u6613\u8bf7\u6c42\u62a5\u6587\u540e\u7279\u6b8a\u5904\u7406\u5f00\u59cb");
        }
        try {
            afterProcessBytes = this.specialProcess.afterRecvRequest(in);
        }
        catch (Exception e) {
            TranProcessException se = new TranProcessException("after_recv_request", e);
            se.addScene("buff", in);
            se.addScene("exception", e);
            if (log.isErrorEnabled()) {
                log.error((Object)"\u4ea4\u6613\u8bf7\u6c42\u540e\u5904\u7406\u5931\u8d25", (Throwable)e);
            }
            throw se;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u63a5\u5230\u4ea4\u6613\u8bf7\u6c42\u62a5\u6587\u540e\u7279\u6b8a\u5904\u7406\u7ed3\u675f");
        }
        this.inpacket = new InputPacket(afterProcessBytes);
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u4ea4\u6613\u62c6\u5305\u524d\u7279\u6b8a\u5904\u7406");
        }
        try {
            this.specialProcess.beforeUnpack(this.inpacket, this.headData);
        }
        catch (Exception e) {
            TranProcessException se = new TranProcessException("before_unpack", e);
            se.addScene("buff", this.inpacket.getBuff());
            se.addScene("data", this.headData);
            se.addScene("exception", e);
            if (log.isErrorEnabled()) {
                log.error((Object)"\u62c6\u5305\u524d\u5904\u7406\u5931\u8d25", (Throwable)e);
            }
            throw se;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u5f00\u59cb\u83b7\u53d6\u4f20\u7edf\u6e20\u9053\u7684\u4ea4\u6613\u53f7");
        }
        if ((tranName = this.specialProcess.getTranName(this.inpacket, this.headData)) == null || tranName.equals("")) {
            if (log.isErrorEnabled()) {
                log.error((Object)"\u65e0\u6cd5\u83b7\u53d6\u4ea4\u6613\u53f7\uff0c\u4ea4\u6613\u8bc6\u522b\u5931\u8d25\uff01");
            }
            IdentifyTranException ce = new IdentifyTranException();
            if (log.isErrorEnabled()) {
                log.error((Object)"\u4ea4\u6613\u8bc6\u522b\u5931\u8d25", (Throwable)ce);
            }
            throw ce;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u4ea4\u6613\u53f7[" + tranName + "]"));
        }
        if ((tranConfig = this.channelConfig.getTran(tranName)) == null) {
            IdentifyTranException ce = new IdentifyTranException();
            if (log.isErrorEnabled()) {
                log.error((Object)"\u4ea4\u6613\u8bc6\u522b\u6709\u8bef\uff01\u65e0\u6cd5\u83b7\u5f97\u76f8\u5e94\u7684\u914d\u7f6e\u4fe1\u606f\uff01");
            }
            throw ce;
        }
        this.setConfig(tranConfig);
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u4ea4\u6613\u8bc6\u522b\u6210\u529f\uff01");
        }
    }

    public CompositeData unpack(Object request) {
        String mode;
        if (log.isInfoEnabled()) {
            log.info((Object)"\u4f20\u7edf\u6e20\u9053\u4ea4\u6613\u62c6\u5305\u5904\u7406\u5f00\u59cb");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u62c6\u62a5\u6587\u4f53\u5f00\u59cb");
        }
        if ((mode = this.config.getRequest().getPackageMode()) == null || mode == "") {
            IdentifyTranException ce = new IdentifyTranException();
            ce.addScene("channel", this.channelConfig.getName());
            ce.addScene("tran", this.config.getName());
            if (log.isErrorEnabled()) {
                log.error((Object)"\u4f20\u7edf\u6e20\u9053\u4ea4\u6613\u8bf7\u6c42\u62a5\u6587\u4f53\u7684\u5305\u6a21\u5f0f\u914d\u7f6e\u4e0d\u5b58\u5728\uff01");
            }
            throw ce;
        }
        PackageConverter converter = PackageModeFactory.getFactory().getPackageMode(mode);
        if (converter == null) {
            IdentifyTranException ce = new IdentifyTranException();
            ce.addScene("channel", this.channelConfig.getName());
            ce.addScene("tran", this.config.getName());
            ce.addScene("modename", mode);
            if (log.isErrorEnabled()) {
                log.error((Object)"\u4f20\u7edf\u6e20\u9053\u4ea4\u6613\u8bf7\u6c42\u62a5\u6587\u4f53\u7684\u5305\u6a21\u5f0f\u4e0d\u5b58\u5728\uff01\u914d\u7f6e\u6709\u8bef\uff01", (Throwable)ce);
                throw ce;
            }
        }
        try {
            converter.unpack(this.inpacket, this.headData, this.config.getRequest().getIOConfig());
        }
        catch (Exception e) {
            TranDataConvertProcessException de = new TranDataConvertProcessException("unpack", e);
            if (log.isErrorEnabled()) {
                log.error((Object)"\u4f20\u7edf\u6e20\u9053\u62c6\u5305\u5931\u8d25", (Throwable)e);
            }
            throw de;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u62a5\u6587\u4f53\u62c6\u5305\u7ed3\u675f");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u62a5\u6587\u4f53\u6620\u5c04\u524d\u5904\u7406");
        }
        try {
            this.specialProcess.beforeMapIn(this.headData);
        }
        catch (Exception e) {
            TranProcessException se = new TranProcessException("before_map_in", e);
            se.addScene("data", this.headData);
            if (log.isErrorEnabled()) {
                log.error((Object)"\u8bf7\u6c42\u6620\u5c04\u524d\u5904\u7406\u5931\u8d25", (Throwable)e);
            }
            throw se;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u62a5\u6587\u4f53\u7684\u6620\u5c04\u5f00\u59cb");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u62a5\u6587\u4f53\u7684\u6620\u5c04\u524d\u6570\u636e:" + this.headData));
        }
        try {
            ExpressionDataMapper mapper = new ExpressionDataMapper(this.config.getRequestMapper());
            mapper.map(this.headData, this.headData);
        }
        catch (Exception e) {
            TranDataConvertProcessException de = new TranDataConvertProcessException("map_in", e);
            if (log.isErrorEnabled()) {
                log.error((Object)"\u8bf7\u6c42\u6620\u5c04\u5931\u8d25", (Throwable)e);
            }
            throw de;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u4f20\u7edf\u6e20\u9053\u8bf7\u6c42\u4ea4\u6613\u6620\u5c04\u540e\u7684\u6570\u636e:" + this.headData));
        }
        if (log.isInfoEnabled()) {
            log.debug((Object)"\u4f20\u7edf\u6e20\u9053\u4ea4\u6613\u62c6\u5305\u5904\u7406\u7ed3\u675f");
        }
        return this.headData;
    }

    public String getServiceName() {
        String svrName;
        if (log.isInfoEnabled()) {
            log.info((Object)"\u4ea4\u6613\u5f00\u59cb\u83b7\u53d6\u5bf9\u5e94\u7684\u670d\u52a1\u540d\u79f0");
        }
        if ((svrName = this.config.getServiceName()) == null || svrName.equals("")) {
            if (log.isErrorEnabled()) {
                log.error((Object)"\u65e0\u6cd5\u83b7\u53d6\u4ea4\u6613\u5bf9\u5e94\u7684\u670d\u52a1\u540d\u79f0.");
            }
            GetServiceNameException te = new GetServiceNameException(this.config.getName());
            throw te;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("\u4ea4\u6613[" + this.config.getName() + "]\u5bf9\u5e94\u7684\u670d\u52a1\u540d\u79f0[" + svrName + "]"));
        }
        return svrName;
    }

    public Object pack(CompositeData response) {
        byte[] after;
        OutputPacket outpacket = new OutputPacket();
        if (log.isInfoEnabled()) {
            log.info((Object)"\u4f20\u7edf\u6e20\u9053\u4ea4\u6613\u7ec4\u5305\u5f00\u59cb:");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u4f20\u7edf\u6e20\u9053\u4ea4\u6613\u7ec4\u5305\u6620\u5c04\u524d\u7279\u6b8a\u5904\u7406");
        }
        try {
            this.specialProcess.beforeMapOut(response);
        }
        catch (Exception e) {
            TranProcessException se = new TranProcessException("before_map_out", e);
            se.addScene("data", response);
            if (log.isErrorEnabled()) {
                log.error((Object)"\u54cd\u5e94\u6620\u5c04\u524d\u5904\u7406\u5931\u8d25", (Throwable)e);
            }
            throw se;
        }
        try {
            ExpressionDataMapper mapper = new ExpressionDataMapper(this.config.getResponseMapper());
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u4ea4\u6613\u7ec4\u5305\u524d\u6620\u5c04\u5904\u7406\uff0c\u6620\u5c04\u524d\u6570\u636e\uff1a\n" + response));
            }
            mapper.map(response, response);
        }
        catch (Exception e) {
            TranDataConvertProcessException de = new TranDataConvertProcessException("map_out", e);
            if (log.isErrorEnabled()) {
                log.error((Object)"\u54cd\u5e94\u6620\u5c04\u5931\u8d25", (Throwable)e);
            }
            throw de;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u4ea4\u6613\u7ec4\u5305\u524d\u6620\u5c04\u5904\u7406\uff0c\u6620\u5c04\u540e\u6570\u636e\uff1a\n" + response));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u4f20\u7edf\u6e20\u9053\u4ea4\u6613\u7ec4\u5305\u6620\u5c04\u524d\u7279\u6b8a\u5904\u7406");
        }
        try {
            this.specialProcess.beforePack(outpacket, response);
        }
        catch (Exception e) {
            TranProcessException se = new TranProcessException("before_pack", e);
            se.addScene("buff", outpacket.getBuff());
            se.addScene("response", response);
            if (log.isErrorEnabled()) {
                log.error((Object)"\u4f20\u7edf\u6e20\u9053\u8fd4\u56de\u7ec4\u5305\u524d\u5904\u7406\u5931\u8d25", (Throwable)e);
            }
            throw se;
        }
        String mode = this.config.getResponse().getPackageMode();
        if (mode == null || mode == "") {
            TranDataConvertProcessException ce = new TranDataConvertProcessException("pack");
            ce.addScene("channel", this.channelConfig.getName());
            ce.addScene("tran", this.config.getName());
            if (log.isErrorEnabled()) {
                log.error((Object)"\u4f20\u7edf\u6e20\u9053\u4ea4\u6613\u54cd\u5e94\u62a5\u6587\u4f53\u7684\u5305\u6a21\u5f0f\u540d\u79f0\u4e0d\u5b58\u5728\uff01", (Throwable)ce);
            }
            throw ce;
        }
        PackageConverter converter = PackageModeFactory.getFactory().getPackageMode(mode);
        if (converter == null) {
            TranDataConvertProcessException ce = new TranDataConvertProcessException("pack");
            ce.addScene("channel", this.channelConfig.getName());
            ce.addScene("tran", this.config.getName());
            ce.addScene("modename", mode);
            if (log.isErrorEnabled()) {
                log.error((Object)"\u4f20\u7edf\u6e20\u9053\u4ea4\u6613\u8fd4\u56de\u62a5\u6587\u4f53\u7ec4\u5305\u5931\u8d25\uff0c\u5305\u6a21\u5f0f\u914d\u7f6e\u4e0d\u5b58\u5728", (Throwable)ce);
            }
            throw ce;
        }
        try {
            converter.pack(outpacket, response, this.config.getResponse().getIOConfig());
        }
        catch (Exception e) {
            TranDataConvertProcessException de = new TranDataConvertProcessException("pack", e);
            de.addScene("buff", outpacket.getBuff());
            de.addScene("response", response);
            if (log.isErrorEnabled()) {
                log.error((Object)"\u4f20\u7edf\u6e20\u9053\u8fd4\u56de\u62a5\u6587\u4f53\u7ec4\u5305\u5931\u8d25", (Throwable)e);
            }
            throw de;
        }
        byte[] outBytes = new byte[outpacket.getOffset()];
        System.arraycopy(outpacket.getBuff(), 0, outBytes, 0, outpacket.getOffset());
        try {
            after = this.specialProcess.beforeSendResponse(outBytes);
        }
        catch (Exception e) {
            TranProcessException se = new TranProcessException("before_send_response", e);
            se.addScene("buff", outpacket.getBuff());
            se.addScene("response", response);
            if (log.isErrorEnabled()) {
                log.error((Object)"\u4f20\u7edf\u6e20\u9053\u54cd\u5e94\u8fd4\u56de\u524d\u5904\u7406\u5931\u8d25", (Throwable)e);
            }
            throw se;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"\u4f20\u7edf\u6e20\u9053\u4ea4\u6613\u7ec4\u5305\u7ed3\u675f");
        }
        return after;
    }

    public Object packError(CompositeData response) {
        byte[] after;
        if (log.isInfoEnabled()) {
            log.info((Object)"\u4f20\u7edf\u6e20\u9053\u4ea4\u6613\u7ec4\u9519\u8bef\u5305\u5f00\u59cb");
        }
        OutputPacket out = new OutputPacket();
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u4ea4\u6613\u9519\u8bef\u5904\u7406-\u7ec4\u5305\u6620\u5c04\u524d\u5904\u7406");
        }
        try {
            this.specialProcess.beforeMapOut(response);
        }
        catch (Exception e) {
            TranProcessException se = new TranProcessException("before_map_out", e);
            se.addScene("response", response);
            if (log.isErrorEnabled()) {
                log.error((Object)"\u4f20\u7edf\u6e20\u9053\u9519\u8bef\u62a5\u6587\u5934\u6620\u5c04\u5904\u7406\u5931\u8d25", (Throwable)e);
            }
            throw se;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u4ea4\u6613\u9519\u8bef\u5904\u7406-\u7ec4\u9519\u8bef\u5305\u6620\u5c04\u5904\u7406,\u6620\u5c04\u524d\u6570\u636e\uff1a\n" + response));
        }
        try {
            if (this.config.getErrorMapper() != null) {
                ExpressionDataMapper mapper = new ExpressionDataMapper(this.config.getErrorMapper());
                mapper.map(response, response);
            }
        }
        catch (Exception e) {
            TranDataConvertProcessException se = new TranDataConvertProcessException("map_in", e);
            se.addScene("response", response);
            if (log.isErrorEnabled()) {
                log.error((Object)"\u4f20\u7edf\u6e20\u9053\u9519\u8bef\u62a5\u6587\u4f53\u6620\u5c04\u5904\u7406\u5931\u8d25", (Throwable)e);
            }
            throw se;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u4ea4\u6613\u9519\u8bef\u5904\u7406-\u7ec4\u9519\u8bef\u5305\u6620\u5c04\u5904\u7406,\u6620\u5c04\u540e\u6570\u636e\uff1a\n" + response));
        }
        try {
            this.specialProcess.beforePackError(out, response);
        }
        catch (Exception e) {
            TranProcessException se = new TranProcessException("before_pack_error", e);
            se.addScene("buff", out.getBuff());
            se.addScene("response", response);
            if (log.isErrorEnabled()) {
                log.error((Object)"\u4f20\u7edf\u6e20\u9053\u7ec4\u9519\u8bef\u62a5\u6587\u5934\u5904\u7406\u5931\u8d25", (Throwable)e);
            }
            throw se;
        }
        PackageConfig packconfig = this.config.getError();
        if (packconfig != null) {
            String mode = packconfig.getPackageMode();
            if (mode == null || mode.equals("")) {
                TranDataConvertProcessException ce = new TranDataConvertProcessException("pack");
                ce.addScene("channel", this.channelConfig.getName());
                ce.addScene("tran", this.config.getName());
                if (log.isErrorEnabled()) {
                    log.error((Object)"\u4f20\u7edf\u6e20\u9053\u4ea4\u6613\u54cd\u5e94\u9519\u8bef\u62a5\u6587\u5305\u6a21\u5f0f\u914d\u7f6e\u4e0d\u5b58\u5728\uff01", (Throwable)ce);
                }
                throw ce;
            }
            PackageConverter converter = PackageModeFactory.getFactory().getPackageMode(mode);
            if (converter == null) {
                TranDataConvertProcessException ce = new TranDataConvertProcessException("pack");
                ce.addScene("channel", this.channelConfig.getName());
                ce.addScene("tran", this.config.getName());
                ce.addScene("modename", mode);
                if (log.isErrorEnabled()) {
                    log.error((Object)"\u4f20\u7edf\u6e20\u9053\u4ea4\u6613\u54cd\u5e94\u9519\u8bef\u62a5\u6587\u4f53\u7684\u5305\u6a21\u5f0f\u4e0d\u5b58\u5728\uff01\u914d\u7f6e\u9519\u8bef\uff01", (Throwable)ce);
                }
                throw ce;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u4ea4\u6613\u9519\u8bef\u5904\u7406-\u5f00\u59cb\u7ec4\u9519\u8bef\u5305\n");
            }
            try {
                converter.pack(out, response, packconfig.getIOConfig());
            }
            catch (Exception e) {
                TranDataConvertProcessException de = new TranDataConvertProcessException("pack", e);
                de.addScene("buff", out.getBuff());
                de.addScene("response", response);
                if (log.isErrorEnabled()) {
                    log.error((Object)"\u4f20\u7edf\u6e20\u9053\u8fd4\u56de\u9519\u8bef\u62a5\u6587\u4f53\u7ec4\u5305\u5931\u8d25", (Throwable)e);
                }
                throw de;
            }
        }
        byte[] outBytes = new byte[out.getOffset()];
        System.arraycopy(out.getBuff(), 0, outBytes, 0, out.getOffset());
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u4ea4\u6613\u9519\u8bef\u54cd\u5e94\u62a5\u6587\u53d1\u9001\u524d\u5904\u7406");
        }
        try {
            after = this.specialProcess.beforeSendResponse(outBytes);
        }
        catch (Exception e) {
            TranProcessException se = new TranProcessException("before_send_response", e);
            se.addScene("buff", outBytes);
            if (log.isErrorEnabled()) {
                log.error((Object)"\u4f20\u7edf\u6e20\u9053\u8fd4\u56de\u62a5\u6587\u5931\u8d25", (Throwable)e);
            }
            throw se;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"\u4f20\u7edf\u6e20\u9053\u4ea4\u6613\u7ec4\u9519\u8bef\u5305\u7ed3\u675f\u3002");
        }
        return after;
    }

    /*
     * Unable to fully structure code
     */
    public Object packSystemError(String errCode, String errMsg) {
        if (TraditionalTran.log.isInfoEnabled()) {
            TraditionalTran.log.info((Object)"\u4f20\u7edf\u6e20\u9053\u4ea4\u6613\u5f02\u5e38\u5904\u7406\u7ec4\u9519\u8bef\u5305\u5f00\u59cb");
        }
        response = new CompositeData();
        fld = new Field(new FieldAttr(FieldType.FIELD_STRING, errCode.length()));
        fld.setValue(errCode);
        response.addField("errCode", fld);
        fld = new Field(new FieldAttr(FieldType.FIELD_STRING, errCode.length()));
        fld.setValue(errMsg);
        response.addField("errMsg", fld);
        out = new OutputPacket();
        try {
            this.specialProcess.beforeMapOut(response);
        }
        catch (Exception e) {
            se = new TranProcessException("before_map_out", e);
            se.addScene("response", response);
            if (TraditionalTran.log.isErrorEnabled()) {
                TraditionalTran.log.error((Object)"\u4f20\u7edf\u6e20\u9053\u9519\u8bef\u62a5\u6587\u7684\u6620\u5c04\u524d\u5904\u7406\u5931\u8d25", (Throwable)e);
            }
            throw se;
        }
        if (this.config.getSystemErrorMapper() != null) {
            try {
                mapper = new ExpressionDataMapper(this.config.getSystemErrorMapper());
                mapper.map(response, response);
                if (!TraditionalTran.log.isDebugEnabled()) ** GOTO lbl35
                TraditionalTran.log.debug((Object)("\u4ea4\u6613\u5f02\u5e38\u5904\u7406-\u7ec4\u9519\u8bef\u5305\u6620\u5c04\u5904\u7406,\u6620\u5c04\u540e\u6570\u636e\uff1a\n" + response));
            }
            catch (Exception e) {
                se = new TranDataConvertProcessException("map_in", e);
                se.addScene("response", response);
                if (TraditionalTran.log.isErrorEnabled()) {
                    TraditionalTran.log.error((Object)"\u4f20\u7edf\u6e20\u9053\u9519\u8bef\u62a5\u6587\u4f53\u6620\u5c04\u5931\u8d25", (Throwable)e);
                }
                throw se;
            }
        } else if (TraditionalTran.log.isDebugEnabled()) {
            TraditionalTran.log.debug((Object)"\u4ea4\u6613\u5f02\u5e38\u5904\u7406-\u6ca1\u6709\u6620\u5c04\u914d\u7f6e\uff01");
        }
lbl35:
        // 5 sources

        try {
            this.specialProcess.beforePackSystemError(out, response);
        }
        catch (Exception e) {
            se = new TranProcessException("before_pack_system_error", e);
            se.addScene("buff", out.getBuff());
            se.addScene("response", response);
            if (TraditionalTran.log.isErrorEnabled()) {
                TraditionalTran.log.error((Object)"\u4f20\u7edf\u6e20\u9053\u7ec4\u62a5\u6587\u5934\u5904\u7406\u5931\u8d25", (Throwable)e);
            }
            throw se;
        }
        packconfig = this.config.getError();
        if (packconfig != null) {
            mode = packconfig.getPackageMode();
            if (mode == null || mode == "") {
                ce = new TranDataConvertProcessException("pack");
                ce.addScene("channel", this.channelConfig.getName());
                ce.addScene("tran", this.config.getName());
                if (TraditionalTran.log.isErrorEnabled()) {
                    TraditionalTran.log.error((Object)"\u4f20\u7edf\u6e20\u9053\u4ea4\u6613\u8fd4\u56de\u9519\u8bef\u62a5\u6587\u4f53\u7ec4\u5305\u5931\u8d25\uff0c\u5305\u6a21\u5f0f\u540d\u79f0\u4e3a\u7a7a", (Throwable)ce);
                }
                throw ce;
            }
            converter = PackageModeFactory.getFactory().getPackageMode(mode);
            if (converter == null) {
                ce = new TranDataConvertProcessException("pack");
                ce.addScene("channel", this.channelConfig.getName());
                ce.addScene("tran", this.config.getName());
                ce.addScene("modename", mode);
                if (TraditionalTran.log.isErrorEnabled()) {
                    TraditionalTran.log.error((Object)"\u4f20\u7edf\u6e20\u9053\u4ea4\u6613\u8fd4\u56de\u9519\u8bef\u62a5\u6587\u4f53\u7ec4\u5305\u5931\u8d25\uff0c\u5305\u6a21\u5f0f\u4e0d\u5b58\u5728", (Throwable)ce);
                }
                throw ce;
            }
            if (TraditionalTran.log.isDebugEnabled()) {
                TraditionalTran.log.debug((Object)"\u4ea4\u6613\u5f02\u5e38\u5904\u7406-\u5f00\u59cb\u7ec4\u9519\u8bef\u5305\n");
            }
            try {
                converter.pack(out, response, this.config.getError().getIOConfig());
            }
            catch (Exception e) {
                de = new TranDataConvertProcessException("pack", e);
                de.addScene("buff", out.getBuff());
                de.addScene("response", response);
                if (TraditionalTran.log.isErrorEnabled()) {
                    TraditionalTran.log.error((Object)"\u4f20\u7edf\u6e20\u9053\u7ec4\u9519\u8bef\u62a5\u6587\u4f53\u7ec4\u5305\u5931\u8d25", (Throwable)e);
                }
                throw de;
            }
        }
        outBytes = new byte[out.getOffset()];
        System.arraycopy(out.getBuff(), 0, outBytes, 0, out.getOffset());
        if (TraditionalTran.log.isDebugEnabled()) {
            TraditionalTran.log.debug((Object)"\u4ea4\u6613\u5f02\u5e38\u54cd\u5e94\u62a5\u6587\u53d1\u9001\u524d\u5904\u7406");
        }
        try {
            after = this.specialProcess.beforeSendResponse(outBytes);
        }
        catch (Exception e) {
            se = new TranProcessException("before_send_response", e);
            se.addScene("buff", outBytes);
            if (TraditionalTran.log.isErrorEnabled()) {
                TraditionalTran.log.error((Object)"\u4f20\u7edf\u6e20\u9053\u8fd4\u56de\u9519\u8bef\u62a5\u6587\u524d\u5904\u7406\u5931\u8d25", (Throwable)e);
            }
            throw se;
        }
        if (TraditionalTran.log.isInfoEnabled()) {
            TraditionalTran.log.info((Object)"\u4f20\u7edf\u6e20\u9053\u4ea4\u6613\u5f02\u5e38\u7ec4\u9519\u8bef\u5305\u7ed3\u675f\u3002");
        }
        return after;
    }

    public TranConfig getConfig() {
        return this.config;
    }

    public void setConfig(TranConfig config) {
        this.config = config;
    }
}

