/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.channel.traditional;

import com.dc.eai.channel.Channel;
import com.dc.eai.channel.Tran;
import com.dc.eai.channel.exception.ChannelDataConvertProcessException;
import com.dc.eai.channel.exception.ChannelProcessException;
import com.dc.eai.channel.exception.IllegalRequestDataException;
import com.dc.eai.channel.traditional.ChannelSpecialProcess;
import com.dc.eai.channel.traditional.TraditionalTran;
import com.dc.eai.config.ChannelConfig;
import com.dc.eai.conv.ExpressionDataMapper;
import com.dc.eai.conv.OutputPacket;
import com.dc.eai.conv.PackageConverter;
import com.dc.eai.conv.PackageModeFactory;
import com.dc.eai.data.CompositeData;
import com.dc.eai.data.Field;
import com.dc.eai.data.FieldAttr;
import com.dc.eai.data.FieldType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TraditionalChannel
implements Channel {
    private static Log log = LogFactory.getLog((Class)TraditionalChannel.class);
    private ChannelConfig config;
    private ChannelSpecialProcess specialProcess;

    public Tran getTran(Object data) {
        if (log.isInfoEnabled()) {
            log.info((Object)"\u4f20\u7edf\u6e20\u9053\u5904\u7406\u5f00\u59cb");
        }
        if (!(data instanceof byte[])) {
            log.error((Object)"\u6e20\u9053\u8bf7\u6c42\u6570\u636e\u7c7b\u578b\u9519\u8bef\uff01");
            IllegalRequestDataException ce = new IllegalRequestDataException(data);
            ce.addScene("\u9700\u8981\u7684\u7c7b\u578b", "byte[]");
            if (log.isErrorEnabled()) {
                log.error((Object)("\u5b9e\u9645\u7c7b\u578b" + data.getClass()));
            }
            throw ce;
        }
        byte[] inBytes = (byte[])data;
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u539f\u59cb\u8bf7\u6c42\u6570\u636e\uff1a" + new String(inBytes)));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u4ea4\u6613\u62c6\u5305\u524d\u9884\u5904\u7406\u5f00\u59cb");
        }
        TraditionalTran tran = new TraditionalTran(this.specialProcess, this.config);
        tran.beforeUnpack(inBytes);
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u4ea4\u6613\u62c6\u5305\u524d\u9884\u5904\u7406\u7ed3\u675f");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"\u6e20\u9053\u5904\u7406\u83b7\u53d6\u4ea4\u6613\u5bf9\u8c61\u7ed3\u675f");
        }
        return tran;
    }

    public Object processError(String errCode, String errMsg) {
        byte[] after;
        if (log.isInfoEnabled()) {
            log.info((Object)"\u4f20\u7edf\u6e20\u9053\u7ec4\u7cfb\u7edf\u9519\u8bef\u5305\u5f00\u59cb\uff1a\n");
        }
        OutputPacket out = new OutputPacket();
        CompositeData data = new CompositeData();
        Field fld = new Field(new FieldAttr(FieldType.FIELD_STRING, errCode.length()));
        fld.setValue(errCode);
        data.addField("errCode", fld);
        fld = new Field(new FieldAttr(FieldType.FIELD_STRING, errMsg.length()));
        fld.setValue(errMsg);
        data.addField("errMsg", fld);
        if (this.config.getSystemErrorMapper() != null) {
            ExpressionDataMapper mapper = new ExpressionDataMapper(this.config.getSystemErrorMapper());
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u6e20\u9053\u5f02\u5e38\u5904\u7406-\u6570\u636e\u6620\u5c04\u5f00\u59cb");
            }
            mapper.map(data, data);
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u6e20\u9053\u5f02\u5e38\u5904\u7406-\u6570\u636e\u6620\u5c04\u7ed3\u675f");
            }
        }
        try {
            this.specialProcess.beforePackSystemError(out, data);
        }
        catch (Exception e) {
            ChannelProcessException ce = new ChannelProcessException("before_pack", e);
            ce.addScene("buff", out.getBuff());
            if (log.isErrorEnabled()) {
                log.error((Object)"\u6e20\u9053\u62c6\u5305\u524d\u5904\u7406\u5931\u8d25", (Throwable)e);
            }
            throw ce;
        }
        PackageModeFactory factory = PackageModeFactory.getFactory();
        try {
            PackageConverter errConverter = factory.getPackageMode(this.config.getError().getPackageMode());
            errConverter.pack(out, data, this.config.getError().getIOConfig());
        }
        catch (Exception e) {
            ChannelDataConvertProcessException ce = new ChannelDataConvertProcessException("pack_system_error", e);
            if (log.isErrorEnabled()) {
                log.error((Object)"\u7ec4\u9519\u8bef\u62a5\u6587\u4f53\u5931\u8d25", (Throwable)e);
            }
            throw ce;
        }
        byte[] outBytes = new byte[out.getOffset()];
        System.arraycopy(out.getBuff(), 0, outBytes, 0, out.getOffset());
        try {
            after = this.specialProcess.beforeSendResponse(outBytes);
        }
        catch (Exception e) {
            ChannelProcessException se = new ChannelProcessException("before_send_response", e);
            se.addScene("buff", outBytes);
            if (log.isErrorEnabled()) {
                log.error((Object)"\u6e20\u9053\u8fd4\u56de\u62a5\u6587\u524d\u5904\u7406\u5931\u8d25", (Throwable)e);
            }
            throw se;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"\u4f20\u7edf\u6e20\u9053\u7ec4\u7cfb\u7edf\u9519\u8bef\u5305\u7ed3\u675f\u3002\n");
        }
        return after;
    }

    public ChannelConfig getConfig() {
        return this.config;
    }

    public void setSpecialProcess(ChannelSpecialProcess specialProcess) {
        this.specialProcess = specialProcess;
    }

    public void setConfig(ChannelConfig config) {
        this.config = config;
    }
}

