/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.channel.selfbyte;

import com.dc.eai.channel.Tran;
import com.dc.eai.channel.exception.GetServiceNameException;
import com.dc.eai.channel.exception.IdentifyTranException;
import com.dc.eai.channel.exception.TranDataConvertProcessException;
import com.dc.eai.channel.exception.TranProcessException;
import com.dc.eai.channel.selfbyte.ChannelSpecialProcess;
import com.dc.eai.config.ChannelConfig;
import com.dc.eai.config.TranConfig;
import com.dc.eai.conv.ExpressionDataMapper;
import com.dc.eai.conv.InputPacket;
import com.dc.eai.conv.OutputPacket;
import com.dc.eai.conv.PackageConverter;
import com.dc.eai.conv.PackageModeFactory;
import com.dc.eai.data.CompositeData;
import com.dc.eai.data.Field;
import com.dc.eai.data.FieldAttr;
import com.dc.eai.data.FieldType;
import com.dc.util.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SelfEvidentByteTran
implements Tran {
    private static Log log = LogFactory.getLog((Class)SelfEvidentByteTran.class);
    private TranConfig config;
    private PackageConverter errConverter;
    private PackageConverter reqConverter;
    private PackageConverter respConverter;
    private ChannelConfig channelConfig;
    private ChannelSpecialProcess specialProcess;
    private CompositeData data;

    public void setDataAfterUnpack(CompositeData dataAfterUnpack) {
        this.data = dataAfterUnpack;
    }

    public SelfEvidentByteTran(ChannelSpecialProcess specialProcess, ChannelConfig configtemp) {
        this.specialProcess = specialProcess;
        this.channelConfig = configtemp;
        this.initConv();
    }

    private void initConv() {
        PackageModeFactory factory = PackageModeFactory.getFactory();
        this.errConverter = factory.getPackageMode(this.channelConfig.getDefaultErrorPackageMode());
        if (this.errConverter == null) {
            TranDataConvertProcessException ce = new TranDataConvertProcessException("pack");
            ce.addScene("mode", this.channelConfig.getDefaultErrorPackageMode());
            ce.addScene("msg", "\u9519\u8bef\u62a5\u6587\u5305\u6a21\u5f0f\u4e0d\u5b58\u5728");
            throw ce;
        }
        this.reqConverter = factory.getPackageMode(this.channelConfig.getDefaultRequestPackageMode());
        if (this.reqConverter == null) {
            TranDataConvertProcessException ce = new TranDataConvertProcessException("pack");
            ce.addScene("mode", this.channelConfig.getDefaultRequestPackageMode());
            ce.addScene("msg", "\u8bf7\u6c42\u62a5\u6587\u5305\u6a21\u5f0f\u4e0d\u5b58\u5728");
            throw ce;
        }
        this.respConverter = factory.getPackageMode(this.channelConfig.getDefaultResponsePackageMode());
        if (this.respConverter == null) {
            TranDataConvertProcessException ce = new TranDataConvertProcessException("pack");
            ce.addScene("mode", this.channelConfig.getDefaultResponsePackageMode());
            ce.addScene("msg", "\u54cd\u5e94\u62a5\u6587\u5305\u6a21\u5f0f\u4e0d\u5b58\u5728");
            throw ce;
        }
    }

    void preprocess(byte[] in, CompositeData requestData) {
        TranConfig tc;
        String tranName;
        byte[] afterRequest;
        this.data = requestData;
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u81ea\u63cf\u8ff0\u5b57\u8282\u578b\u6e20\u9053\u4ea4\u6613\u5904\u7406\u5f00\u59cb");
        }
        try {
            afterRequest = this.specialProcess.afterRecvRequest(in);
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u4ea4\u6613\u8bf7\u6c42\u521d\u6b65\u5904\u7406\u7ed3\u675f");
            }
        }
        catch (Exception e) {
            TranProcessException se = new TranProcessException("after_recv_request", e);
            se.addScene("buff", in);
            se.addScene("exception", e);
            if (log.isErrorEnabled()) {
                log.error((Object)"\u4ea4\u6613\u8bf7\u6c42\u521d\u6b65\u5904\u7406\u5931\u8d25", (Throwable)e);
            }
            throw se;
        }
        InputPacket packet = new InputPacket(afterRequest);
        try {
            this.reqConverter.unpack(packet, this.data, null);
        }
        catch (Exception e) {
            TranDataConvertProcessException de = new TranDataConvertProcessException("unpack", e);
            if (log.isErrorEnabled()) {
                log.error((Object)"\u81ea\u63cf\u8ff0\u5b57\u8282\u578b\u62a5\u6587\u62c6\u5305\u5931\u8d25", (Throwable)e);
            }
            de.addScene("exception", e);
            throw de;
        }
        try {
            this.specialProcess.beforeUnpack(packet, this.data);
        }
        catch (Exception e) {
            TranProcessException se = new TranProcessException("before_unpack", e);
            se.addScene("buff", packet.getBuff());
            se.addScene("data", this.data);
            se.addScene("msg", "\u4ea4\u6613\u62c6\u5305\u524d\u5904\u7406\u5931\u8d25");
            se.addScene("exception", e);
            if (log.isErrorEnabled()) {
                log.error((Object)"\u81ea\u63cf\u8ff0\u5b57\u8282\u6e20\u9053\u4ea4\u6613\u62c6\u5305\u524d\u5904\u7406\u5931\u8d25", (Throwable)e);
            }
            throw se;
        }
        if (this.channelConfig.getRequestHeadMapper() != null) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"\u62a5\u6587\u5934\u6620\u5c04\u5f00\u59cb");
                }
                ExpressionDataMapper mapper = new ExpressionDataMapper(this.channelConfig.getRequestHeadMapper());
                mapper.map(this.data, this.data);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"\u62a5\u6587\u5934\u6620\u5c04\u7ed3\u675f\u3002");
                }
            }
            catch (Exception e) {
                TranDataConvertProcessException de = new TranDataConvertProcessException("map_in", e);
                de.addScene("data", this.data);
                de.addScene("msg", "\u62a5\u6587\u5934\u6620\u5c04\u5931\u8d25");
                de.addScene("exception", e);
                throw de;
            }
        }
        if ((tranName = this.specialProcess.getTranName(packet, this.data)) == null || tranName.equals("")) {
            IdentifyTranException ce = new IdentifyTranException();
            ce.addScene("msg", "\u4ea4\u6613\u8bc6\u522b\u5931\u8d25\uff0c\u65e0\u6cd5\u83b7\u5f97\u4ea4\u6613\u7801");
            throw ce;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u4ea4\u6613\u7801\uff1a" + tranName));
        }
        if ((tc = this.channelConfig.getTran(tranName)) == null) {
            IdentifyTranException ce = new IdentifyTranException();
            ce.addScene("tran", tranName);
            ce.addScene("msg", "\u4ea4\u6613\u8bc6\u522b\u5931\u8d25\uff0c\u65e0\u6cd5\u83b7\u5f97\u76f8\u5e94\u7684\u4ea4\u6613\u914d\u7f6e\u4fe1\u606f");
            throw ce;
        }
        this.setConfig(tc);
    }

    public String getServiceName() {
        String serviceName = this.config.getServiceName();
        if (serviceName == null || serviceName.equals("")) {
            GetServiceNameException te = new GetServiceNameException(this.config.getName());
            te.addScene("msg", "\u4ea4\u6613\u8bc6\u522b\u5931\u8d25\uff0c\u65e0\u6cd5\u83b7\u53d6\u4ea4\u6613\u5bf9\u5e94\u7684\u670d\u52a1\u540d\u79f0");
            throw te;
        }
        return serviceName;
    }

    public Object pack(CompositeData response) {
        OutputPacket packet = new OutputPacket();
        this.specialProcess.beforePack(packet, response);
        if (this.config.getResponseMapper() != null) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"\u7ec4\u5305\u524d\u6620\u5c04\u5f00\u59cb.....");
                }
                ExpressionDataMapper mapper = new ExpressionDataMapper(this.config.getResponseMapper());
                mapper.map(response, response);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("\u7ec4\u5305\u5b8c\u6620\u5c04\u7ed3\u675f\uff0c\u7ed3\u679c\uff1a\n" + response));
                }
            }
            catch (Exception e) {
                TranDataConvertProcessException de = new TranDataConvertProcessException("map_out", e);
                de.addScene("response", response);
                de.addScene("msg", "\u54cd\u5e94\u6620\u5c04\u5931\u8d25");
                de.addScene("exception", e);
                throw de;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u4ea4\u6613\u54cd\u5e94\u7ec4\u5305\u5f00\u59cb.....");
        }
        this.respConverter.pack(packet, response, this.config.getResponse().getIOConfig());
        byte[] bytes = new byte[packet.getOffset()];
        System.arraycopy(packet.getBuff(), 0, bytes, 0, packet.getOffset());
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u4ea4\u6613\u54cd\u5e94\u7ec4\u5305\u7ed3\u675f\uff0c\u54cd\u5e94\u62a5\u6587[ " + new String(bytes) + " ]"));
        }
        try {
            bytes = this.specialProcess.beforeSendResponse(bytes);
        }
        catch (Exception e) {
            TranProcessException se = new TranProcessException("before_send_response", e);
            se.addScene("response", bytes);
            se.addScene("msg", "\u4ea4\u6613\u54cd\u5e94\u8fd4\u56de\u524d\u5904\u7406\u5931\u8d25");
            se.addScene("exception", e);
            throw se;
        }
        return bytes;
    }

    public CompositeData unpack(Object request) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u4ea4\u6613\u8bf7\u6c42\u62c6\u5305\u5f00\u59cb.....");
        }
        if (this.config.getRequestMapper() != null) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"\u62a5\u6587\u6620\u5c04\u5f00\u59cb.....");
                }
                ExpressionDataMapper mapper = new ExpressionDataMapper(this.config.getRequestMapper());
                mapper.map(this.data, this.data);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"\u62a5\u6587\u6620\u5c04\u7ed3\u675f.....");
                }
            }
            catch (Exception e) {
                TranDataConvertProcessException de = new TranDataConvertProcessException("map_in", e);
                de.addScene("request", this.data);
                de.addScene("msg", "\u8bf7\u6c42\u6620\u5c04\u5931\u8d25");
                de.addScene("exception", e);
                throw de;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u4ea4\u6613\u8bf7\u6c42\u62c6\u5305\u7ed3\u675f\uff0c\u8bf7\u6c42\u6570\u636e[ " + this.data + " ]"));
        }
        return this.data;
    }

    public Object packError(CompositeData response) {
        OutputPacket packet = new OutputPacket();
        this.specialProcess.beforePackError(packet, response);
        if (this.config.getErrorMapper() != null) {
            try {
                ExpressionDataMapper mapper = new ExpressionDataMapper(this.config.getErrorMapper());
                mapper.map(response, response);
            }
            catch (Exception e) {
                TranDataConvertProcessException de = new TranDataConvertProcessException("map_out", e);
                de.addScene("response", response);
                de.addScene("msg", "\u5e94\u7528\u9519\u8bef\u6620\u5c04\u5931\u8d25");
                de.addScene("exception", e);
                throw de;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u9519\u8bef\u62a5\u6587\u7ec4\u5305\u5f00\u59cb.....");
        }
        try {
            this.errConverter.pack(packet, response, null);
        }
        catch (Exception e) {
            TranDataConvertProcessException de = new TranDataConvertProcessException("pack_error", e);
            de.addScene("response", response);
            de.addScene("msg", "\u5e94\u7528\u9519\u8bef\u62a5\u6587\u7ec4\u5305\u5931\u8d25");
            de.addScene("exception", e);
            throw de;
        }
        byte[] bytes = new byte[packet.getOffset()];
        System.arraycopy(packet.getBuff(), 0, bytes, 0, packet.getOffset());
        try {
            bytes = this.specialProcess.beforeSendResponse(bytes);
        }
        catch (Exception e) {
            TranProcessException se = new TranProcessException("before_send_response", e);
            se.addScene("response", bytes);
            se.addScene("msg", "\u4ea4\u6613\u5e94\u7528\u9519\u8bef\u54cd\u5e94\u8fd4\u56de\u524d\u5904\u7406\u5931\u8d25");
            se.addScene("exception", e);
            throw se;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u9519\u8bef\u62a5\u6587\u7ec4\u5305\u7ed3\u675f\uff0c\u62a5\u6587[ " + StringUtils.bytesToString(bytes) + " ]"));
        }
        return bytes;
    }

    public Object packSystemError(String errCode, String errMsg) {
        OutputPacket packet = new OutputPacket();
        CompositeData data = new CompositeData();
        this.specialProcess.beforePackSystemError(packet, data);
        Field fld = new Field(new FieldAttr(FieldType.FIELD_STRING, errCode.length()));
        fld.setValue(errCode);
        data.addField("errCode", fld);
        fld = new Field(new FieldAttr(FieldType.FIELD_STRING, errCode.length()));
        fld.setValue(errMsg);
        data.addField("errMsg", fld);
        try {
            if (this.config.getSystemErrorMapper() != null) {
                ExpressionDataMapper mapper = new ExpressionDataMapper(this.config.getSystemErrorMapper());
                mapper.map(data, data);
            }
        }
        catch (Exception e) {
            TranDataConvertProcessException de = new TranDataConvertProcessException("map_out", e);
            de.addScene("data", data);
            de.addScene("msg", "\u7cfb\u7edf\u9519\u8bef\u6620\u5c04\u5931\u8d25");
            de.addScene("exception", e);
            throw de;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u4ea4\u6613\u7cfb\u7edf\u5f02\u5e38\u62a5\u6587\u7ec4\u5305\u5f00\u59cb,\u7ec4\u5305\u524d\u6570\u636e\u4e3a\uff1a\n" + data));
        }
        try {
            this.errConverter.pack(packet, data, this.config.getResponse().getIOConfig());
        }
        catch (Exception e) {
            TranDataConvertProcessException de = new TranDataConvertProcessException("pack_system_error", e);
            de.addScene("data", data);
            de.addScene("msg", "\u7cfb\u7edf\u9519\u8bef\u62a5\u6587\u7ec4\u5305\u5931\u8d25");
            de.addScene("exception", e);
            throw de;
        }
        byte[] bytes = new byte[packet.getOffset()];
        System.arraycopy(packet.getBuff(), 0, bytes, 0, packet.getOffset());
        try {
            bytes = this.specialProcess.beforeSendResponse(bytes);
        }
        catch (Exception e) {
            TranProcessException se = new TranProcessException("before_send_response", e);
            se.addScene("response", bytes);
            se.addScene("msg", "\u4ea4\u6613\u7cfb\u7edf\u9519\u8bef\u54cd\u5e94\u8fd4\u56de\u524d\u5904\u7406\u5931\u8d25");
            se.addScene("exception", e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u4ea4\u6613\u7cfb\u7edf\u5f02\u5e38\u62a5\u6587\u7ec4\u5305\u7ed3\u675f\uff0c\u62a5\u6587[ " + StringUtils.bytesToString(bytes) + " ]"));
        }
        return bytes;
    }

    public TranConfig getConfig() {
        return this.config;
    }

    public void setConfig(TranConfig config) {
        this.config = config;
    }
}

