/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.channel.selfbyte;

import com.dc.eai.channel.Channel;
import com.dc.eai.channel.Tran;
import com.dc.eai.channel.exception.ChannelDataConvertProcessException;
import com.dc.eai.channel.exception.IdentifyTranException;
import com.dc.eai.channel.exception.IllegalRequestDataException;
import com.dc.eai.channel.selfbyte.ChannelSpecialProcess;
import com.dc.eai.channel.selfbyte.SelfEvidentByteTran;
import com.dc.eai.config.ChannelConfig;
import com.dc.eai.conv.ExpressionDataMapper;
import com.dc.eai.conv.OutputPacket;
import com.dc.eai.conv.PackageConverter;
import com.dc.eai.conv.PackageModeFactory;
import com.dc.eai.data.CompositeData;
import com.dc.eai.data.Field;
import com.dc.eai.data.FieldAttr;
import com.dc.eai.data.FieldType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SelfEvidentByteChannel
implements Channel {
    private static Log log = LogFactory.getLog((Class)SelfEvidentByteChannel.class);
    private ChannelConfig config;
    private ChannelSpecialProcess specialProcess;

    public Tran getTran(Object data) {
        if (!(data instanceof byte[])) {
            if (log.isDebugEnabled()) {
                log.error((Object)"\u6e20\u9053\u8bf7\u6c42\u6570\u636e\u7c7b\u578b\u9519\u8bef\uff01");
            }
            IllegalRequestDataException ce = new IllegalRequestDataException(data);
            ce.addScene("\u9700\u8981\u7684\u7c7b\u578b", "byte[]");
            throw ce;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u8bf7\u6c42\u539f\u59cb\u6570\u636e\uff1a" + new String((byte[])data)));
        }
        SelfEvidentByteTran tran = new SelfEvidentByteTran(this.specialProcess, this.config);
        CompositeData compData = new CompositeData();
        try {
            tran.preprocess((byte[])data, compData);
        }
        catch (Exception e) {
            IdentifyTranException ce = new IdentifyTranException();
            ce.addScene("request", data);
            ce.addScene("data", compData);
            throw ce;
        }
        return tran;
    }

    public Object processError(String errCode, String errMsg) {
        CompositeData data = new CompositeData();
        Field fld = new Field(new FieldAttr(FieldType.FIELD_STRING, errCode.length()));
        fld.setValue(errCode);
        data.addField("errCode", fld);
        fld = new Field(new FieldAttr(FieldType.FIELD_STRING, errCode.length()));
        fld.setValue(errMsg);
        data.addField("errMsg", fld);
        try {
            if (this.config.getSystemErrorMapper() != null) {
                ExpressionDataMapper mapper = new ExpressionDataMapper(this.config.getSystemErrorMapper());
                mapper.map(data, data);
            }
        }
        catch (Exception e) {
            ChannelDataConvertProcessException de = new ChannelDataConvertProcessException("map_out", e);
            de.addScene("data", data);
            de.addScene("msg", "\u7cfb\u7edf\u9519\u8bef\u6620\u5c04\u5931\u8d25");
            de.addScene("exception", e);
            if (log.isErrorEnabled()) {
                log.error((Object)"\u81ea\u63cf\u8ff0\u5b57\u8282\u6e20\u9053\u7cfb\u7edf\u9519\u8bef\u6620\u5c04\u5931\u8d25", (Throwable)e);
            }
            throw de;
        }
        OutputPacket packet = new OutputPacket();
        try {
            this.specialProcess.beforePackSystemError(packet, data);
        }
        catch (Exception e) {
            ChannelDataConvertProcessException de = new ChannelDataConvertProcessException("map_out", e);
            de.addScene("data", data);
            if (log.isErrorEnabled()) {
                log.error((Object)"\u81ea\u63cf\u8ff0\u5b57\u8282\u6e20\u9053\u7cfb\u7edf\u9519\u8bef\u7ec4\u62a5\u6587\u524d\u5904\u7406\u5931\u8d25", (Throwable)e);
            }
            throw de;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u6e20\u9053\u5f02\u5e38\u62a5\u6587\u7ec4\u5305\u5f00\u59cb.....");
        }
        PackageModeFactory factory = PackageModeFactory.getFactory();
        try {
            PackageConverter errConverter = factory.getPackageMode(this.config.getDefaultErrorPackageMode());
            errConverter.pack(packet, data, null);
        }
        catch (Exception e) {
            ChannelDataConvertProcessException de = new ChannelDataConvertProcessException("pack", e);
            de.addScene("data", data);
            de.addScene("msg", "\u7cfb\u7edf\u9519\u8bef\u7ec4\u5305\u5931\u8d25");
            if (log.isErrorEnabled()) {
                log.error((Object)"\u81ea\u63cf\u8ff0\u5b57\u8282\u6e20\u9053\u7cfb\u7edf\u9519\u8bef\u7ec4\u5305\u5931\u8d25", (Throwable)e);
            }
            throw de;
        }
        byte[] out = packet.getBuff();
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u6e20\u9053\u5f02\u5e38\u62a5\u6587\u7ec4\u5305\u7ed3\u675f");
        }
        return out;
    }

    public ChannelConfig getConfig() {
        return this.config;
    }

    public void setConfig(ChannelConfig config) {
        this.config = config;
    }

    public void setSpecialProcess(ChannelSpecialProcess specialProcess) {
        this.specialProcess = specialProcess;
    }
}

