/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.channel.object;

import com.dc.eai.channel.exception.GetServiceNameException;
import com.dc.eai.channel.object.AbstractObjectTran;
import com.dc.eai.channel.object.ObjectDataChannelConfig;
import com.dc.eai.channel.object.ObjectDataTranConfig;
import com.dc.eai.channel.object.exception.TranReflectException;
import com.dc.eai.config.TranConfig;
import com.dc.eai.data.CompositeData;
import com.dc.eai.data.Field;
import com.dc.eai.data.FieldAttr;
import com.dc.eai.data.FieldType;
import com.dc.eai.pack.objectdata.ObjectDataConfig;
import com.dc.eai.pack.objectdata.ObjectDataConverter;
import com.dc.eai.pack.objectdata.ObjectDataConverterFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObjectDataTran
extends AbstractObjectTran {
    private ObjectDataConverter errConverter;
    private ObjectDataConverter requestConverter;
    private ObjectDataConverter responseConverter;
    private ObjectDataChannelConfig channelConfig;
    private ObjectDataTranConfig config;
    private static Log log = LogFactory.getLog((Class)ObjectDataTran.class);

    public ObjectDataTran(ObjectDataChannelConfig config) {
        this.channelConfig = config;
        this.initConv();
    }

    public CompositeData unpack(Object request) {
        if (log.isInfoEnabled()) {
            log.info((Object)"ObjectDataChannel\u6e20\u9053\u62c6\u5305\u5f00\u59cb.....");
        }
        ObjectDataTranConfig tranConfig = this.config;
        ObjectDataConfig dataConfig = tranConfig.getDataRequest();
        CompositeData comData = new CompositeData();
        this.requestConverter.unPack(request, comData, dataConfig);
        if (log.isInfoEnabled()) {
            log.info((Object)("ObjectDataChannel\u6e20\u9053\u62c6\u5305\u7ed3\u675f,\u62c6\u5305\u7ed3\u679c\u4e3a:" + comData));
        }
        return comData;
    }

    public String getServiceName() {
        String svrName;
        if (log.isInfoEnabled()) {
            log.info((Object)"ObjectDataTran\u5f00\u59cb\u83b7\u53d6\u670d\u52a1\u540d\u79f0");
        }
        if ((svrName = this.config.getServiceName()) == null || svrName.equals("")) {
            if (log.isErrorEnabled()) {
                log.error((Object)"\u4ea4\u6613\u8bc6\u522b\u5931\u8d25\uff01");
                log.error((Object)"\u65e0\u6cd5\u83b7\u53d6\u4ea4\u6613\u5bf9\u5e94\u7684\u670d\u52a1\u540d\u79f0.");
            }
            GetServiceNameException te = new GetServiceNameException("serverName_noexist_Exception");
            if (log.isErrorEnabled()) {
                log.error((Object)("\u4ea4\u6613\u53f7" + this.config.getName()));
                log.error((Object)("\u4ea4\u6613\u5bf9\u5e94\u7684\u670d\u52a1" + svrName));
            }
            throw te;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"ObjectDataTran\u83b7\u53d6\u670d\u52a1\u540d\u79f0\u7ed3\u675f");
        }
        return svrName;
    }

    public Object pack(CompositeData response) {
        if (log.isInfoEnabled()) {
            log.info((Object)"ObjectDataChannel\u6e20\u9053\u8fd4\u56de\u62a5\u6587\u7ec4\u5305\u5f00\u59cb.....");
        }
        ObjectDataTranConfig tranConfig = this.config;
        ObjectDataConfig dataConfig = tranConfig.getDataResponse();
        Object responseObject = ObjectDataTran.beforePack(dataConfig);
        this.requestConverter.pack(responseObject, response, dataConfig);
        if (log.isInfoEnabled()) {
            log.info((Object)"ObjectDataChannel\u6e20\u9053\u8fd4\u56de\u62a5\u6587\u7ec4\u5305\u7ed3\u675f");
        }
        return responseObject;
    }

    public Object packError(CompositeData response) {
        if (log.isInfoEnabled()) {
            log.info((Object)"ObjectDataChannel\u6e20\u9053\u5f02\u5e38\u62a5\u6587\u7ec4\u5305\u5f00\u59cb.....");
        }
        ObjectDataTranConfig tranConfig = this.config;
        ObjectDataConfig dataConfig = tranConfig.getDataError();
        Object errprObject = ObjectDataTran.beforePack(dataConfig);
        this.requestConverter.pack(errprObject, response, dataConfig);
        if (log.isInfoEnabled()) {
            log.info((Object)"ObjectDataChannel\u6e20\u9053\u5f02\u5e38\u62a5\u6587\u7ec4\u5305\u7ed3\u675f");
        }
        return errprObject;
    }

    public Object packSystemError(String errCode, String errMsg) {
        ObjectDataConfig dataConfig;
        Object obj = null;
        CompositeData data = new CompositeData();
        Field fld = new Field(new FieldAttr(FieldType.FIELD_STRING, errCode.length()));
        fld.setValue(errCode);
        data.addField("errCode", fld);
        fld = new Field(new FieldAttr(FieldType.FIELD_STRING, errCode.length()));
        fld.setValue(errMsg);
        data.addField("errMsg", fld);
        if (log.isInfoEnabled()) {
            log.info((Object)"ObjectDataChannel\u6e20\u9053\u7cfb\u7edf\u5f02\u5e38\u62a5\u6587\u7ec4\u5305\u5f00\u59cb.....");
        }
        if ((dataConfig = this.config.getSystemError()) == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u4ea4\u6613\u6ca1\u6709\u5b9a\u4e49\u7cfb\u7edf\u5f02\u5e38\u914d\u7f6e,\u4f7f\u7528\u6e20\u9053\u7684\u7cfb\u7edf\u5f02\u5e38\u914d\u7f6e");
            }
            dataConfig = this.channelConfig.getSystemError();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"ObjectDataChannel\u6e20\u9053\u7cfb\u7edf\u5f02\u5e38\u62a5\u6587\u7ec4\u5305\u524d\u5904\u7406\u5f00\u59cb.....");
        }
        obj = ObjectDataTran.beforePack(dataConfig);
        if (log.isDebugEnabled()) {
            log.debug((Object)"ObjectDataChannel\u6e20\u9053\u7cfb\u7edf\u5f02\u5e38\u62a5\u6587\u7ec4\u5305\u524d\u5904\u7406\u5b8c\u6210.....");
        }
        this.errConverter.pack(obj, data, dataConfig);
        if (log.isInfoEnabled()) {
            log.info((Object)("ObjectDataChannel\u6e20\u9053\u5f02\u5e38\u62a5\u6587\u7ec4\u5305\u7ed3\u675f.....out[" + data + "]"));
        }
        return obj;
    }

    private void initConv() {
        if (this.requestConverter == null) {
            this.requestConverter = ObjectDataConverterFactory.getInstance().getConverter("request-converter");
        }
        if (this.responseConverter == null) {
            this.responseConverter = ObjectDataConverterFactory.getInstance().getConverter("reponse-converter");
        }
        if (this.errConverter == null) {
            this.errConverter = ObjectDataConverterFactory.getInstance().getConverter("error-converter");
        }
    }

    static Object beforePack(ObjectDataConfig dataConfig) {
        try {
            Object object = Class.forName(dataConfig.getClsName()).newInstance();
            return object;
        }
        catch (Exception e) {
            TranReflectException ie = new TranReflectException("\u65e0\u6cd5\u4ece\u7ed9\u5b9a\u7684name\u83b7\u5f97object");
            if (log.isErrorEnabled()) {
                log.error((Object)"\u65e0\u6cd5\u4ece\u7ed9\u5b9a\u7684name\u83b7\u5f97object", (Throwable)ie);
            }
            throw ie;
        }
    }

    public TranConfig getConfig() {
        return this.getObjectDataTranConfig();
    }

    public void setObjectDataTranConfig(ObjectDataTranConfig config) {
        this.config = config;
    }

    public ObjectDataTranConfig getObjectDataTranConfig() {
        return this.config;
    }
}

