/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.aop.proxy;

import com.dc.eai.aop.AopUtils;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.aopalliance.aop.AspectException;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class ReflectiveMethodInvocation
implements MethodInvocation,
Cloneable {
    protected final Object proxy;
    protected final Object target;
    protected final Method method;
    protected Object[] arguments;
    private final Class targetClass;
    protected final List interceptors;
    private int currentInterceptorIndex = -1;

    public ReflectiveMethodInvocation(Object proxy, Object target, Method method, Object[] arguments, Class targetClass, List interceptors) {
        this.proxy = proxy;
        this.target = target;
        this.targetClass = targetClass;
        this.method = method;
        this.arguments = arguments;
        this.interceptors = interceptors;
    }

    public final Object getProxy() {
        return this.proxy;
    }

    public final Object getThis() {
        return this.target;
    }

    public final AccessibleObject getStaticPart() {
        return this.method;
    }

    public final Method getMethod() {
        return this.method;
    }

    public final Object[] getArguments() {
        return this.arguments;
    }

    public Object proceed() throws Throwable {
        if (this.currentInterceptorIndex == this.interceptors.size() - 1) {
            return this.invokeJoinpoint();
        }
        Object interceptorOrInterceptionAdvice = this.interceptors.get(++this.currentInterceptorIndex);
        return ((MethodInterceptor)interceptorOrInterceptionAdvice).invoke((MethodInvocation)this);
    }

    protected Object invokeJoinpoint() throws Throwable {
        return AopUtils.invokeJoinpointUsingReflection(this.target, this.method, this.arguments);
    }

    public MethodInvocation invocableClone() {
        try {
            ReflectiveMethodInvocation clone = (ReflectiveMethodInvocation)this.clone();
            if (this.arguments != null) {
                clone.arguments = new Object[this.arguments.length];
                System.arraycopy(this.arguments, 0, clone.arguments, 0, this.arguments.length);
            }
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            throw new AspectException("Should be able to clone object of " + this.getClass(), (Throwable)ex);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Invocation: method '");
        sb.append(this.method.getName()).append("', ").append("arguments ");
        sb.append(this.arguments != null ? Arrays.asList(this.arguments).toString() : "[]");
        sb.append("; ");
        if (this.target == null) {
            sb.append("target is null");
        } else {
            sb.append("target is of class [").append(this.target.getClass().getName()).append(']');
        }
        return sb.toString();
    }
}

