/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.aop.proxy;

import com.dc.eai.aop.AopProxy;
import com.dc.eai.aop.AopUtils;
import com.dc.eai.aop.TargetSource;
import com.dc.eai.aop.proxy.AopConfigException;
import com.dc.eai.aop.proxy.AopProxyUtils;
import com.dc.eai.aop.proxy.ProxyConfig;
import com.dc.eai.aop.proxy.ReflectiveMethodInvocation;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class JdkDynamicAopProxy
implements AopProxy,
InvocationHandler,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Log logger = LogFactory.getLog((Class)JdkDynamicAopProxy.class);
    private ProxyConfig config;

    public JdkDynamicAopProxy(ProxyConfig config) throws AopConfigException {
        if (config == null) {
            throw new AopConfigException("Cannot_create_AopProxy_with_null_ProxyConfig");
        }
        if (config.getAdvisors().length == 0 && config.getTargetSource() == null) {
            throw new AopConfigException("Cannot_create_AopProxy_with_no_advisors_and_no_target_source");
        }
        this.config = config;
    }

    public Object getProxy() {
        return this.getProxy(Thread.currentThread().getContextClassLoader());
    }

    public Object getProxy(ClassLoader classLoader) {
        if (logger.isDebugEnabled()) {
            Class targetClass = this.config.getTargetSource().getTargetClass();
            logger.debug((Object)("Creating JDK dynamic proxy" + (targetClass != null ? " for [" + targetClass.getName() + "]" : "")));
        }
        Class[] proxiedInterfaces = AopProxyUtils.completeProxiedInterfaces(this.config);
        return Proxy.newProxyInstance(classLoader, proxiedInterfaces, (InvocationHandler)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object object;
        block13: {
            List chain;
            Object target;
            Class<?> targetClass;
            TargetSource targetSource;
            ReflectiveMethodInvocation invocation;
            block11: {
                Integer n;
                block12: {
                    block9: {
                        Boolean bl;
                        block10: {
                            invocation = null;
                            targetSource = this.config.getTargetSource();
                            targetClass = null;
                            target = null;
                            try {
                                if (!AopUtils.isEqualsMethod(method)) break block9;
                                Boolean bl2 = bl = this.equals(args[0]) ? Boolean.TRUE : Boolean.FALSE;
                                if (target == null || targetSource.isStatic()) break block10;
                            }
                            catch (Throwable throwable) {
                                if (target != null && !targetSource.isStatic()) {
                                    targetSource.releaseTarget(target);
                                }
                                throw throwable;
                            }
                            targetSource.releaseTarget(target);
                        }
                        return bl;
                    }
                    if (!AopUtils.isHashCodeMethod(method)) break block11;
                    n = new Integer(this.hashCode());
                    if (target == null || targetSource.isStatic()) break block12;
                    targetSource.releaseTarget(target);
                }
                return n;
            }
            Object retVal = null;
            target = targetSource.getTarget();
            if (target != null) {
                targetClass = target.getClass();
            }
            if ((chain = this.config.advisorChainFactory.getInterceptors(this.config, proxy, method, targetClass)).isEmpty()) {
                retVal = AopUtils.invokeJoinpointUsingReflection(target, method, args);
            } else {
                invocation = new ReflectiveMethodInvocation(proxy, target, method, args, targetClass, chain);
                retVal = invocation.proceed();
            }
            if (retVal != null && retVal == target) {
                retVal = proxy;
            }
            object = retVal;
            if (target == null || targetSource.isStatic()) break block13;
            targetSource.releaseTarget(target);
        }
        return object;
    }

    public int hashCode() {
        return this.config.getTargetSource().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        JdkDynamicAopProxy aopr2 = null;
        if (other instanceof JdkDynamicAopProxy) {
            aopr2 = (JdkDynamicAopProxy)other;
        } else if (Proxy.isProxyClass(other.getClass())) {
            InvocationHandler ih = Proxy.getInvocationHandler(other);
            if (!(ih instanceof JdkDynamicAopProxy)) {
                return false;
            }
            aopr2 = (JdkDynamicAopProxy)ih;
        } else {
            return false;
        }
        return AopProxyUtils.equalsInProxy(this.config, aopr2.config);
    }
}

