/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.aop.proxy;

import com.dc.eai.aop.proxy.ProxyConfig;
import java.util.Arrays;

public abstract class AopProxyUtils {
    public static Class[] completeProxiedInterfaces(ProxyConfig config) {
        Class[] proxiedInterfacesOnConfig = config.getProxiedInterfaces() == null ? new Class[]{} : config.getProxiedInterfaces();
        int lengthFromConfig = proxiedInterfacesOnConfig.length;
        Class[] proxiedInterfaces = new Class[lengthFromConfig];
        System.arraycopy(proxiedInterfacesOnConfig, 0, proxiedInterfaces, 0, proxiedInterfacesOnConfig.length);
        return proxiedInterfaces;
    }

    public static boolean equalsInProxy(ProxyConfig a, ProxyConfig b) {
        if (a == b) {
            return true;
        }
        if (!AopProxyUtils.equalsProxiedInterfaces(a, b)) {
            return false;
        }
        if (!AopProxyUtils.equalsAdvisors(a, b)) {
            return false;
        }
        if (a.getTargetSource() == null) {
            return b.getTargetSource() == null;
        }
        return a.getTargetSource().equals(b.getTargetSource());
    }

    public static boolean equalsProxiedInterfaces(ProxyConfig a, ProxyConfig b) {
        return Arrays.equals(a.getProxiedInterfaces(), b.getProxiedInterfaces());
    }

    public static boolean equalsAdvisors(ProxyConfig a, ProxyConfig b) {
        return Arrays.equals(a.getAdvisors(), b.getAdvisors());
    }
}

