/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.aop.proxy;

import com.dc.eai.aop.Advisor;
import com.dc.eai.aop.MethodMatcher;
import com.dc.eai.aop.adapter.AdvisorAdapterRegistry;
import com.dc.eai.aop.adapter.GlobalAdvisorAdapterRegistry;
import com.dc.eai.aop.proxy.AdvisorChainFactory;
import com.dc.eai.aop.proxy.MethodInterceptorProxy;
import com.dc.eai.aop.proxy.ProxyConfig;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.aopalliance.intercept.MethodInterceptor;

public abstract class AdvisorChainFactoryUtils {
    public static final AdvisorChainFactory SIMPLE_ADVISOR_CHAIN_FACTORY = new AdvisorChainFactory(){

        public List getInterceptors(ProxyConfig config, Object proxy, Method method, Class targetClass) {
            return AdvisorChainFactoryUtils.calculateInterceptorsAndDynamicInterceptionAdvice(config, proxy, method, targetClass);
        }
    };

    public static List calculateInterceptorsAndDynamicInterceptionAdvice(ProxyConfig config, Object proxy, Method method, Class targetClass) {
        ArrayList<MethodInterceptor> interceptors = new ArrayList<MethodInterceptor>(config.getAdvisors().length);
        AdvisorAdapterRegistry registry = GlobalAdvisorAdapterRegistry.getInstance();
        for (int i = 0; i < config.getAdvisors().length; ++i) {
            Advisor advisor = config.getAdvisors()[i];
            if (!advisor.getPointcut().getClassFilter().matches(targetClass)) continue;
            MethodInterceptor interceptor = (MethodInterceptor)registry.getInterceptor(advisor);
            MethodMatcher mm = advisor.getPointcut().getMethodMatcher();
            if (!mm.matches(method, targetClass)) continue;
            if (mm.isRuntime()) {
                interceptors.add(new MethodInterceptorProxy(advisor.getPointcut(), interceptor));
                continue;
            }
            interceptors.add(interceptor);
        }
        return interceptors;
    }
}

