/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.aop.adapter;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ThrowsAdviceInterceptor
implements MethodInterceptor {
    private static final String AFTER_THROWING = "afterThrowing";
    protected static Log logger = LogFactory.getLog((Class)ThrowsAdviceInterceptor.class);
    private Object throwsAdvice;
    private Map exceptionHandlerHash;
    static /* synthetic */ Class class$java$lang$Throwable;

    public ThrowsAdviceInterceptor(Object throwsAdvice) {
        this.throwsAdvice = throwsAdvice;
        Method[] methods = throwsAdvice.getClass().getMethods();
        this.exceptionHandlerHash = new HashMap();
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            if (!m.getName().equals(AFTER_THROWING) || m.getParameterTypes().length != 1 && m.getParameterTypes().length != 4 || !(class$java$lang$Throwable == null ? ThrowsAdviceInterceptor.class$("java.lang.Throwable") : class$java$lang$Throwable).isAssignableFrom(m.getParameterTypes()[m.getParameterTypes().length - 1])) continue;
            this.exceptionHandlerHash.put(m.getParameterTypes()[m.getParameterTypes().length - 1], m);
            logger.info((Object)("Found exception handler method [" + m + "]"));
        }
        if (this.exceptionHandlerHash.isEmpty()) {
            throw new IllegalArgumentException("At least one handler method must be found in class " + throwsAdvice.getClass());
        }
    }

    public int getHandlerMethodCount() {
        return this.exceptionHandlerHash.size();
    }

    private Method getExceptionHandler(Throwable exception) {
        Class<?> exceptionClass = exception.getClass();
        logger.info((Object)("Trying to find handler for exception of " + exceptionClass));
        Method handler = (Method)this.exceptionHandlerHash.get(exceptionClass);
        while (handler == null && !exceptionClass.equals(class$java$lang$Throwable == null ? ThrowsAdviceInterceptor.class$("java.lang.Throwable") : class$java$lang$Throwable)) {
            logger.info((Object)("Looking at superclass " + exceptionClass));
            exceptionClass = exceptionClass.getSuperclass();
            handler = (Method)this.exceptionHandlerHash.get(exceptionClass);
        }
        return handler;
    }

    public Object invoke(MethodInvocation mi) throws Throwable {
        try {
            return mi.proceed();
        }
        catch (Throwable t) {
            Method handlerMethod = this.getExceptionHandler(t);
            if (handlerMethod != null) {
                this.invokeHandlerMethod(mi, t, handlerMethod);
            }
            throw t;
        }
    }

    private void invokeHandlerMethod(MethodInvocation mi, Throwable t, Method m) throws Throwable {
        Object[] handlerArgs = m.getParameterTypes().length == 1 ? new Object[]{t} : new Object[]{mi.getMethod(), mi.getArguments(), mi.getThis(), t};
        try {
            m.invoke(this.throwsAdvice, handlerArgs);
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
    }
}

