/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.aop.adapter;

import com.dc.eai.aop.Advisor;
import com.dc.eai.aop.DefaultAdvisor;
import com.dc.eai.aop.adapter.AdvisorAdapter;
import com.dc.eai.aop.adapter.AdvisorAdapterRegistry;
import com.dc.eai.aop.adapter.AfterReturningAdviceAdapter;
import com.dc.eai.aop.adapter.BeforeAdviceAdapter;
import com.dc.eai.aop.adapter.ThrowsAdviceAdapter;
import com.dc.eai.aop.adapter.UnknownAdviceTypeException;
import java.util.ArrayList;
import java.util.List;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.Interceptor;

public class DefaultAdvisorAdapterRegistry
implements AdvisorAdapterRegistry {
    private final List adapters = new ArrayList();

    public DefaultAdvisorAdapterRegistry() {
        this.registerAdvisorAdapter(new BeforeAdviceAdapter());
        this.registerAdvisorAdapter(new AfterReturningAdviceAdapter());
        this.registerAdvisorAdapter(new ThrowsAdviceAdapter());
    }

    public Advisor wrap(Object adviceObject) throws UnknownAdviceTypeException {
        if (adviceObject instanceof Advisor) {
            return (Advisor)adviceObject;
        }
        if (!(adviceObject instanceof Advice)) {
            throw new UnknownAdviceTypeException(adviceObject);
        }
        Advice advice = (Advice)adviceObject;
        if (advice instanceof Interceptor) {
            return new DefaultAdvisor(advice);
        }
        for (int i = 0; i < this.adapters.size(); ++i) {
            AdvisorAdapter adapter = (AdvisorAdapter)this.adapters.get(i);
            if (!adapter.supportsAdvice(advice)) continue;
            return new DefaultAdvisor(advice);
        }
        throw new UnknownAdviceTypeException(advice);
    }

    public Interceptor getInterceptor(Advisor advisor) throws UnknownAdviceTypeException {
        Advice advice = advisor.getAdvice();
        if (advice instanceof Interceptor) {
            return (Interceptor)advice;
        }
        for (int i = 0; i < this.adapters.size(); ++i) {
            AdvisorAdapter adapter = (AdvisorAdapter)this.adapters.get(i);
            if (!adapter.supportsAdvice(advice)) continue;
            return adapter.getInterceptor(advisor);
        }
        throw new UnknownAdviceTypeException(advisor.getAdvice());
    }

    public void registerAdvisorAdapter(AdvisorAdapter adapter) {
        this.adapters.add(adapter);
    }
}

