/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.aop;

import com.dc.eai.aop.Advisor;
import com.dc.eai.aop.Pointcut;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.aopalliance.aop.AspectException;

public abstract class AopUtils {
    public static boolean isJdkDynamicProxy(Object object) {
        return Proxy.isProxyClass(object.getClass());
    }

    public static boolean isCglibProxy(Object object) {
        return AopUtils.isCglibProxyClass(object.getClass());
    }

    public static boolean isCglibProxyClass(Class cls) {
        return cls.getName().indexOf("$$") != -1;
    }

    public static boolean isAopProxy(Object object) {
        return AopUtils.isJdkDynamicProxy(object) || AopUtils.isCglibProxy(object);
    }

    public static boolean isEqualsMethod(Method method) {
        return method.getName().equals("equals") && method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == Object.class;
    }

    public static boolean isHashCodeMethod(Method method) {
        return method.getName().equals("hashCode") && method.getParameterTypes().length == 0;
    }

    public static boolean isToStringMethod(Method method) {
        return method.getName().equals("toString") && method.getParameterTypes().length == 0;
    }

    public static Method getMostSpecificMethod(Method method, Class targetClass) {
        if (targetClass != null) {
            try {
                method = targetClass.getMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return method;
    }

    public static Class[] toInterfaceArray(String[] interfaceNames) throws IllegalArgumentException, ClassNotFoundException {
        Class[] interfaces = new Class[interfaceNames.length];
        for (int i = 0; i < interfaceNames.length; ++i) {
            interfaces[i] = Class.forName(interfaceNames[i], true, Thread.currentThread().getContextClassLoader());
            if (interfaces[i].isInterface()) continue;
            throw new IllegalArgumentException("Can proxy only interfaces: " + interfaces[i] + " is a class");
        }
        return interfaces;
    }

    public static Class[] getAllInterfaces(Object object) {
        List interfaces = AopUtils.getAllInterfacesAsList(object);
        return interfaces.toArray(new Class[interfaces.size()]);
    }

    public static String interfacesString(Collection interfaces) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        Iterator itr = interfaces.iterator();
        while (itr.hasNext()) {
            Class intf = (Class)itr.next();
            if (i++ > 0) {
                sb.append(",");
            }
            sb.append(intf.getName());
        }
        return sb.toString();
    }

    public static List getAllInterfacesAsList(Object object) {
        ArrayList interfaces = new ArrayList();
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            for (int i = 0; i < clazz.getInterfaces().length; ++i) {
                Class<?> ifc = clazz.getInterfaces()[i];
                interfaces.add(ifc);
            }
        }
        return interfaces;
    }

    public static boolean methodIsOnOneOfTheseInterfaces(Method method, Class[] interfaces) {
        if (interfaces == null) {
            return false;
        }
        for (int i = 0; i < interfaces.length; ++i) {
            if (!interfaces[i].isInterface()) {
                throw new IllegalArgumentException(interfaces[i].getName() + " is not an interface");
            }
            try {
                interfaces[i].getDeclaredMethod(method.getName(), method.getParameterTypes());
                return true;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
        }
        return false;
    }

    public static boolean canApply(Pointcut pc, Class targetClass, Class[] proxyInterfaces) {
        if (!pc.getClassFilter().matches(targetClass)) {
            return false;
        }
        Method[] methods = targetClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            if (proxyInterfaces != null && !AopUtils.methodIsOnOneOfTheseInterfaces(m, proxyInterfaces) || !pc.getMethodMatcher().matches(m, targetClass)) continue;
            return true;
        }
        return false;
    }

    public static boolean canApply(Advisor advisor, Class targetClass, Class[] proxyInterfaces) {
        return AopUtils.canApply(advisor.getPointcut(), targetClass, proxyInterfaces);
    }

    public static Object invokeJoinpointUsingReflection(Object target, Method method, Object[] args) throws Throwable {
        try {
            return method.invoke(target, args);
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
        catch (IllegalArgumentException ex) {
            throw new AspectException("AOP configuration seems to be invalid: tried calling " + method + " on [" + target + "]: ", (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new AspectException("Couldn't access method " + method, (Throwable)ex);
        }
    }
}

