/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.adapter.tuxedo;

import bea.jolt.JoltRemoteService;
import bea.jolt.JoltSession;
import bea.jolt.JoltSessionAttributes;
import bea.jolt.Session;
import com.dc.eai.adapter.Adapter;
import com.dc.eai.config.AdapterConfig;
import com.dc.util.NumberUtils;
import org.apache.log4j.Category;

public class TuxedoJoltAdapter
implements Adapter {
    private String serverIp;
    private int serverPort;
    private String buffName;
    private String tranPrefix;
    private String tranName;
    private Object tmpVar;
    private byte[] comKey = null;
    private String conKey = null;
    private AdapterConfig config;
    public static int PACKET_LEN = 256;
    public static byte TA_DATA = (byte)2;
    public static byte TA_ACE = (byte)5;
    public static int MAX_BUFSIZE = 65535;
    private static Category _logger = Category.getInstance((String)TuxedoJoltAdapter.class.getName());

    public void setConfig(AdapterConfig config) {
        this.config = config;
    }

    private void loadConfig(AdapterConfig config) {
        this.serverPort = NumberUtils.intValue(config.getAttribute("serverPort"));
        this.serverIp = config.getAttribute("serverIp");
        this.buffName = config.getAttribute("buffName");
        this.tranPrefix = config.getAttribute("tranPrefix");
        this.tranName = config.getAttribute("tranName");
        this.conKey = config.getAttribute("conKey");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doComm(Object request) {
        this.loadConfig(this.config);
        byte[] outBuf = null;
        byte[] trcd = new byte[4];
        byte[] inBuf = (byte[])request;
        String userName = null;
        String userPasswd = null;
        String appPasswd = null;
        String userRole = null;
        JoltSessionAttributes joltSAttr = new JoltSessionAttributes();
        joltSAttr.setString("APPADDRESS", "//" + this.serverIp + ":" + this.serverPort);
        JoltSession joltSession = new JoltSession(joltSAttr, userName, userRole, userPasswd, appPasswd);
        System.arraycopy(inBuf, 0, trcd, 0, 4);
        String strTrcd = new String(trcd);
        JoltRemoteService withdrawal = this.tranName.length() != 0 ? new JoltRemoteService(this.tranName, (Session)joltSession) : new JoltRemoteService(this.tranPrefix + strTrcd, (Session)joltSession);
        try {
            if (!this.conKey.trim().equals("")) {
                this.comKey = this.conKey.getBytes();
            }
            withdrawal.setBytes(this.buffName, inBuf, inBuf.length);
            withdrawal.call(null);
            outBuf = withdrawal.getBytesDef(this.buffName, inBuf);
        }
        catch (Exception ex) {
            _logger.debug((Object)"FTS: Jolt send/read error!");
            joltSession.endSession();
        }
        finally {
            joltSession.endSession();
        }
        return outBuf;
    }

    public AdapterConfig getConfig() {
        return this.config;
    }
}

