/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.adapter.tuxedo;

import com.dc.eai.adapter.Adapter;
import com.dc.eai.adapter.tuxedo.FMLTpPacketConv;
import com.dc.eai.adapter.tuxedo.TpPacket;
import com.dc.eai.adapter.tuxedo.TuxedoFacade;
import com.dc.eai.config.AdapterConfig;
import com.dc.eai.data.CompositeData;
import com.dc.eai.data.Field;
import com.dc.eai.data.FieldAttr;
import com.dc.eai.data.FieldType;
import com.dc.eai.dispatch.Context;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TuxedoAdapter
implements Adapter {
    private static Log log = LogFactory.getLog((Class)TuxedoAdapter.class);
    static HashMap frnt_sna = new HashMap();
    private AdapterConfig config;

    public synchronized Object doComm(Object request) {
        Context context = Context.getInstance();
        if (log.isDebugEnabled()) {
            log.debug((Object)("context includes:" + context));
        }
        byte[] bytes = (byte[])request;
        int size = bytes.length;
        TpPacket r = new TpPacket();
        r.address = 0L;
        r.length = 8192L;
        r.type = "FML32";
        r.subtype = null;
        TpPacket s = new TpPacket();
        s.address = 0L;
        s.length = 8192L;
        s.type = "FML32";
        s.subtype = null;
        TuxedoFacade.tpinit(null);
        TuxedoFacade.tpalloc(s);
        TuxedoFacade.tpalloc(r);
        FMLTpPacketConv stpc = new FMLTpPacketConv(frnt_sna);
        CompositeData scd = new CompositeData();
        Field f = null;
        f = new Field(new FieldAttr(FieldType.FIELD_LONG, 0));
        f.setValue((long)size);
        scd.addField("LENGTH", f);
        f = new Field(new FieldAttr(FieldType.FIELD_LONG, 0));
        f.setValue(0L);
        scd.addField("TYPE", f);
        f = new Field(new FieldAttr(FieldType.FIELD_LONG, 0));
        f.setValue(Long.parseLong(System.getProperty("algorithm.dcc").substring(0, 3)));
        scd.addField("ID", f);
        f = new Field(new FieldAttr(FieldType.FIELD_LONG, 0));
        f.setValue(System.currentTimeMillis() / 1000L);
        if (log.isDebugEnabled()) {
            log.debug((Object)("currentTimeMillis=" + System.currentTimeMillis()));
        }
        scd.addField("OCCURTIME", f);
        f = new Field(new FieldAttr(FieldType.FIELD_STRING, 9));
        f.setValue(Context.getInstance().getBranchId());
        scd.addField("BRANCH", f);
        f = new Field(new FieldAttr(FieldType.FIELD_STRING, 12));
        f.setValue((String)Context.getInstance().getProperty("INM_TELLER_ID"));
        scd.addField("TELLER", f);
        f = new Field(new FieldAttr(FieldType.FIELD_STRING, 9));
        f.setValue(context.getTranName());
        scd.addField("APPTXCODE", f);
        f = new Field(new FieldAttr(FieldType.FIELD_IMAGE, size));
        f.setValue(bytes);
        scd.addField("BUFFER", f);
        f = new Field(new FieldAttr(FieldType.FIELD_IMAGE, 20));
        f.setValue(new byte[20]);
        scd.addField("IFKEY", f);
        stpc.cm_data2tx_data(scd, s);
        CompositeData rcd = new CompositeData();
        f = new Field(new FieldAttr(FieldType.FIELD_IMAGE, 4096));
        f.setValue(new byte[4096]);
        rcd.addField("BUFFER", f);
        f = new Field(new FieldAttr(FieldType.FIELD_IMAGE, 20));
        f.setValue(new byte[20]);
        rcd.addField("IFKEY", f);
        f = new Field(new FieldAttr(FieldType.FIELD_LONG, 0));
        f.setValue((long)size);
        rcd.addField("LENGTH", f);
        if (log.isDebugEnabled()) {
            log.debug((Object)("tpcall request data: " + scd));
        }
        TuxedoFacade.tpcall("SHORT_TRANS", s, r, 0L);
        stpc.tx_data2cm_data(rcd, r);
        if (log.isDebugEnabled()) {
            log.debug((Object)("tpcall response data: " + rcd));
        }
        TuxedoFacade.tpfree(s);
        TuxedoFacade.tpfree(r);
        TuxedoFacade.tpterm();
        int rv_len = rcd.getField("BUFFER").getAttr().getLength();
        byte[] rv = new byte[rv_len];
        System.arraycopy(rcd.getField("BUFFER").imageValue(), 0, rv, 0, rv_len);
        return rv;
    }

    public TuxedoAdapter(AdapterConfig config) {
        this.setConfig(config);
    }

    public AdapterConfig getConfig() {
        return this.config;
    }

    public void setConfig(AdapterConfig config) {
        this.config = config;
    }

    static {
        frnt_sna.put("LENGTH", new Long(33555433L));
        frnt_sna.put("TYPE", new Long(33555434L));
        frnt_sna.put("ID", new Long(33555435L));
        frnt_sna.put("OCCURTIME", new Long(33555436L));
        frnt_sna.put("BUFFER", new Long(201327597L));
        frnt_sna.put("IFKEY", new Long(201327598L));
        frnt_sna.put("BRANCH", new Long(167773167L));
        frnt_sna.put("TELLER", new Long(167773168L));
        frnt_sna.put("APPTXCODE", new Long(167773169L));
    }
}

