/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.adapter.tuxedo;

import com.dc.eai.adapter.tuxedo.AbstractTpPacketConv;
import com.dc.eai.adapter.tuxedo.TpPacket;
import com.dc.eai.data.CompositeData;
import com.dc.eai.data.Field;
import com.dc.eai.data.FieldType;
import java.util.HashMap;
import java.util.Iterator;

public class FMLTpPacketConv
extends AbstractTpPacketConv {
    HashMap fieldName2long;

    public static void init() {
    }

    public FMLTpPacketConv(HashMap fieldName2FLDID32) {
        if (fieldName2FLDID32 == null) {
            throw new IllegalArgumentException("field name to FLDID32 map cannot be null");
        }
        this.fieldName2long = fieldName2FLDID32;
    }

    private long getFLDID32(String fieldName) {
        Long FLDID32 = (Long)this.fieldName2long.get(fieldName);
        if (FLDID32 == null) {
            throw new IllegalStateException("FML field[" + fieldName + "] cannot be found in config");
        }
        return FLDID32;
    }

    public void cm_data2tx_data(CompositeData cd, TpPacket tp) {
        Iterator fldNames = cd.iterator();
        while (fldNames.hasNext()) {
            String fldName = (String)fldNames.next();
            Field fld = cd.getField(fldName);
            if (FieldType.integerType(fld.getFieldType())) {
                this.Fadd32(1, this.getFLDID32(fldName), fld, tp);
                continue;
            }
            if (FieldType.decimalType(fld.getFieldType())) {
                this.Fadd32(3, this.getFLDID32(fldName), fld, tp);
                continue;
            }
            if (FieldType.stringType(fld.getFieldType())) {
                this.Fadd32(5, this.getFLDID32(fldName), fld, tp);
                continue;
            }
            if (fld.getFieldType().equals(FieldType.FIELD_IMAGE)) {
                this.Fadd32(6, this.getFLDID32(fldName), fld, tp);
                continue;
            }
            throw new IllegalStateException("field type of field[" + fld.toString() + "] cannot be accepted");
        }
    }

    public void tx_data2cm_data(CompositeData cd, TpPacket tp) {
        Iterator fldNames = cd.iterator();
        while (fldNames.hasNext()) {
            String fldName = (String)fldNames.next();
            Field fld = cd.getField(fldName);
            if (FieldType.integerType(fld.getFieldType())) {
                this.Fget32(1, this.getFLDID32(fldName), fld, tp);
                continue;
            }
            if (FieldType.decimalType(fld.getFieldType())) {
                this.Fget32(3, this.getFLDID32(fldName), fld, tp);
                continue;
            }
            if (FieldType.stringType(fld.getFieldType())) {
                this.Fget32(5, this.getFLDID32(fldName), fld, tp);
                continue;
            }
            if (fld.getFieldType().equals(FieldType.FIELD_IMAGE)) {
                int size = this.Fget32(6, this.getFLDID32(fldName), fld, tp);
                FMLTpPacketConv.updateImageField(cd, fldName, size);
                continue;
            }
            throw new IllegalStateException("field type of field[" + fld.toString() + "] cannot be accepted");
        }
    }

    public native int Fget32(int var1, long var2, Field var4, TpPacket var5);

    public native int Fadd32(int var1, long var2, Field var4, TpPacket var5);
}

